package org.mulesoft.apb.project.client.scala.model.descriptor.community

import amf.core.client.scala.model.{DateField, StrField}
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.{Field, Type}
import amf.core.internal.metamodel.Type.{DateTime, Int, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.CommunityModel.{
  CreatedAt,
  Portal,
  Profile,
  Target,
  Version,
  entityModel
}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.{ApiCommunity, Catalog}
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}
import org.mulesoft.common.time.SimpleDateTime

import scala.language.implicitConversions

class Community(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {
  override type This = Community

  private implicit def targetConversion(jsonLDObject: JsonLDObject): PortalTarget = PortalTarget.apply(jsonLDObject)

  override protected def fields: Fields = internal.fields

  def portal: String          = get[StrField](Portal)
  def version: Option[String] = get[StrField](Version)
  def target: PortalTarget    = get[JsonLDObject](Target)
  def profiles: Seq[CommunityProfile] = get[Seq[JsonLDObject]](Profile)
    .map(CommunityProfile.apply)
  def createdAt: SimpleDateTime = get[DateField](CreatedAt)

  def withPortal(portal: String): this.type = {
    internal.withProperty(Portal, portal)
    this
  }
  def withVersion(version: String): this.type = {
    internal.withProperty(Version, version)
    this
  }
  def withProfiles(profiles: Seq[CommunityProfile]): this.type = {
    internal.withObjPropertyCollection(Profile, profiles.map(_.internal))
    this
  }
  def withTarget(target: PortalTarget): this.type = {
    internal.withProperty(Target, target)
    this
  }
  def withCreatedAt(createdAt: SimpleDateTime): this.type = {
    internal.withDateTimeProperty(CreatedAt, createdAt)
    this
  }
}

object Community {
  def apply(
      portal: String,
      target: PortalTarget,
      profiles: Seq[CommunityProfile] = Seq(),
      createdAt: SimpleDateTime
  ): Community =
    Community
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withPortal(portal)
      .withTarget(target)
      .withProfiles(profiles)
      .withCreatedAt(createdAt)

  private[apb] def apply(jsonLDObject: JsonLDObject): Community = new Community(jsonLDObject)
}

trait CommunityModel {
  val Portal: Field = Field(Str, ApiCommunity + "portal", doc("portal"))

  val Target: Field = Field(JsonLDElementModel, ApiCommunity + "target", doc("target"))

  val Version: Field = Field(Str, Catalog + "version", doc("version"))

  val Profile: Field = Field(Type.Array(JsonLDElementModel), ApiCommunity + "profile", doc("profiles"))

  val CreatedAt: Field = Field(DateTime, ApiCommunity + "createdAt", doc("createdAt"))

  val `type`: List[ValueType] = List(ApiCommunity + "Community")
  val fields: List[Field]     = List(Portal, Target, Version, Profile, CreatedAt)

  protected def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object CommunityModel extends CommunityModel
