package org.mulesoft.apb.project.client.platform.helper

import amf.shapes.client.scala.config.JsonLDSchemaConfiguration
import amf.shapes.client.platform.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.convert.ShapeClientConverters
import org.yaml.model.YNode
import org.yaml.render.{JsonRender, YamlRender}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
@JSExportTopLevel("GraphHelper")
object GraphHelper {

  private lazy val config = JsonLDSchemaConfiguration.JsonLDSchema()

  private def renderAsYNode(element: JsonLDObject): YNode =
    config.elementClient().renderElement(ShapeClientConverters.JsonLDObjectConverter.asInternal(element))

  def renderToJson(element: JsonLDObject): String = JsonRender.render(renderAsYNode(element))

  def renderToYaml(element: JsonLDObject): String = YamlRender.render(renderAsYNode(element))
}
