package org.mulesoft.apb.project.internal.dependency

import amf.core.client.common.validation.SeverityLevels
import amf.core.client.scala.model.document.ExternalFragment
import amf.core.internal.validation.CoreValidations.UnresolvedReference
import org.mulesoft.apb.project.client.scala.dependency.ParsedDependency
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.scala.model.descriptor.{DependencyScope, ProjectDependency}
import org.mulesoft.apb.project.client.scala.model.report.{APBResult, ProjectAspects}
import org.mulesoft.apb.project.internal.dependency.UnreachableDependency.emptyUnit
import org.mulesoft.apb.project.internal.engine.MigrationRisks
import org.mulesoft.apb.project.internal.validations.ProjectValidations.UnreacheableAsset

private[apb] object UnreachableDependency {
  val emptyUnit = ExternalFragment().withId("unreachable-unit")

  def apply(descriptor: ProjectDescriptor, dependency: ProjectDependency): ParsedDependency = {
    val validation = APBResult(
        s"Asset ${dependency.gav.path()} is unreachable",
        SeverityLevels.VIOLATION,
        "",
        None,
        UnreacheableAsset.id,
        None,
        Some(dependency.gav.path()),
        Unit,
        ProjectAspects.TREE
    )
    new UnreachableDependency(descriptor, List(validation), dependency.scope)
  }

  // TODO change
  def fileNotFound(descriptor: ProjectDescriptor, dependency: ProjectDependency, e: Throwable) = {
    val validation = APBResult(
        e.getMessage,
        SeverityLevels.VIOLATION,
        "",
        None,
        UnresolvedReference.id,
        None,
        Some(dependency.gav.path()),
        Unit,
        ProjectAspects.TREE
    )
    new UnreachableDependency(descriptor, List(validation), dependency.scope)
  }
}

private[apb] case class UnreachableDependency(
    override val descriptor: ProjectDescriptor,
    override val results: Seq[APBResult],
    override val scope: DependencyScope
) extends ParsedDependency(emptyUnit, descriptor, results) {

  def update(migrationRisks: MigrationRisks): UnreachableDependency = this
}
