package org.mulesoft.apb.project.client.platform.config

import amf.apicontract.client.scala.AMFConfiguration
import amf.core.client.platform.resource.ResourceLoader
import org.mulesoft.apb.project.client.platform.model.descriptor.ProjectDescriptor
import org.mulesoft.apb.project.client.platform.{DependencySet => ClientDependencySet}
import org.mulesoft.apb.project.client.scala.config.{AMFConfigurationFactory => InternalAMFConfigurationFactory}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.concurrent.ExecutionContext.Implicits.global
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
@JSExportTopLevel("AMFConfigurationFactory")
object AMFConfigurationFactory {

  def createFromClassifier(descriptor: ProjectDescriptor): AMFConfiguration =
    InternalAMFConfigurationFactory.createFromClassifier(asInternal(descriptor))

  private def asInternal(descriptor: ProjectDescriptor) = {
    ProjectDescriptorConverter.asInternal(descriptor)
  }

  def createFrom(
      config: ClientDependencySet,
      base: AMFConfiguration,
      loaders: ClientList[ResourceLoader]
  ): AMFConfiguration =
    InternalAMFConfigurationFactory.createFrom(asInternal(config), base, loaders.asInternal)

  def createSpecAgnosticParsingConfig(
      config: ClientDependencySet,
      loaders: ClientList[ResourceLoader]
  ): AMFConfiguration = {
    InternalAMFConfigurationFactory.createSpecAgnosticParsingConfig(asInternal(config), loaders.asInternal)
  }

  def createSpecificationParsingConfig(
      config: ClientDependencySet,
      loaders: ClientList[ResourceLoader]
  ): AMFConfiguration = {
    InternalAMFConfigurationFactory.createSpecificationParsingConfig(asInternal(config), loaders.asInternal)
  }

  private def asInternal(config: ClientDependencySet) = {
    DependencySetConverter.asInternal(config)
  }
}
