package org.mulesoft.apb.project.internal.emitter

import amf.core.client.scala.model.domain.AmfObject
import amf.core.internal.render.emitters.PartEmitter
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitScalarField
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel.{AssetId, GroupId, Scope, Version}
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryDependencyEmitter(dependency: AmfObject) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, dependency, GroupId)
      emitScalarField(entryBuilder, dependency, AssetId)
      emitScalarField(entryBuilder, dependency, Version)
      emitScalarField(entryBuilder, dependency, Scope)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryDependencyEmitter {
  def apply(dependency: AmfObject) = new ProjectSummaryDependencyEmitter(dependency)
}
