package org.mulesoft.apb.project.internal.emitter.governance

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{GovernanceInfo, GovernanceInfoModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitJsonLdObject
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryGovernanceInfoEmitter(governanceInfo: GovernanceInfo) extends PartEmitter {

  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitJsonLdObject(entryBuilder, governanceInfo, GovernanceInfoModel.Managed) { validationGroup =>
        ProjectSummaryValidationGroupEmitter(validationGroup)
      }
      emitJsonLdObject(entryBuilder, governanceInfo, GovernanceInfoModel.Unmanaged) { validationGroup =>
        ProjectSummaryValidationGroupEmitter(validationGroup)
      }
    }
  }
  override def position(): Position = Position.ZERO
}
object ProjectSummaryGovernanceInfoEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryGovernanceInfoEmitter(GovernanceInfo(instance))
}
