package org.mulesoft.apb.project.internal.emitter.governance

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{Validation, ValidationModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.{emitJsonLdObject, emitScalarField}
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryValidationEmitter(validation: Validation) extends PartEmitter {

  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, validation, ValidationModel.Urn)
      emitScalarField(entryBuilder, validation, ValidationModel.AssetId)
      emitScalarField(entryBuilder, validation, ValidationModel.Group)
      emitScalarField(entryBuilder, validation, ValidationModel.Version)
      emitScalarField(entryBuilder, validation, ValidationModel.Timestamp)

      emitJsonLdObject(entryBuilder, validation, ValidationModel.Status) { status =>
        ProjectSummaryValidationStatusEmitter(status)
      }
    }
  }
  override def position(): Position = Position.ZERO
}

object ProjectSummaryValidationEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryValidationEmitter(Validation(instance))
}
