package org.mulesoft.apb.project.internal.model

import amf.core.client.scala.model.{BoolField, DateField, IntField, StrField}
import amf.core.internal.metamodel.Field
import amf.core.internal.parser.domain.Fields
import org.mulesoft.common.time.SimpleDateTime

trait UnwrappedFields {

  implicit protected def strOptFieldConversion(optField: StrField): Option[String] = optField.option()

  implicit protected def strFieldConversion(optField: StrField): String = optField.option().getOrElse("")

  implicit protected def boolOptFieldConversion(boolField: BoolField): Option[Boolean] = boolField.option()

  implicit protected def dateOptFieldConversion(dateField: DateField): Option[SimpleDateTime] = dateField.option()

  implicit protected def boolFieldConversion(boolField: BoolField): Boolean = boolField.option().getOrElse(false)

  implicit protected def intOptFieldConversion(intField: IntField): Option[Int] = intField.option()

  implicit protected def strCollectionFieldConversion(collectionField: Seq[StrField]): Seq[String] =
    collectionField.flatMap(_.option())

  implicit protected def fieldToString(field: Field): String = field.toString

  implicit protected def dateFieldConversion(dateField: DateField): SimpleDateTime = dateField.value()

  protected def fields: Fields

  protected def get[T](field: Field): T = fields.field(field)
}
