package org.mulesoft.apb.project.client.scala.model.report

import amf.core.client.common.validation.SeverityLevels.{INFO, VIOLATION, WARNING}
import amf.core.client.scala.validation.AMFValidationReportPrinter.DefaultMax
import amf.core.client.scala.validation.{AMFValidationReportPrinter, ReportConformance}
import org.mulesoft.common.collections._
import org.mulesoft.common.io.Output
import org.mulesoft.common.io.Output.OutputOps

import java.io.StringWriter

class APBReport(override val results: Seq[APBResult]) extends ReportConformance(results) with APBReportPrinter {
  private val DefaultMax = 30

  override def toString: String = toString(DefaultMax)
}

sealed trait APBReportPrinter { this: APBReport =>
  def toString(max: Int): String = {
    val output = new StringWriter
    print(output, max)
    output.toString
  }

  def print[W: Output](writer: W, max: Int = DefaultMax): Unit = {
    writer.append(s"Conforms: ${conforms}\n")
    writer.append(s"Number of results: ${results.length}\n")

    val groupedValidations =
      results.take(max).sortWith((c1, c2) => c1.compare(c2) < 0).legacyGroupBy(_.severityLevel)

    groupedValidations.get(VIOLATION).foreach(violations => appendValidations(VIOLATION, violations, writer))
    groupedValidations.get(WARNING).foreach(violations => appendValidations(WARNING, violations, writer))
    groupedValidations.get(INFO).foreach(violations => appendValidations(INFO, violations, writer))

  }

  def printAPBResult[W: Output](result: APBResult, writer: W): Unit = {
    AMFValidationReportPrinter.print(result, writer)

    writer.append(s"  Aspect: ${result.aspect.name}\n")
  }

  private def appendValidations[W: Output](level: String, validations: Seq[APBResult], writer: W): Unit = {
    writer.append(s"\nLevel: $level\n")
    validations.foreach { result =>
      writer.append("\n")
      printAPBResult(result, writer)
    }
  }
}
