package org.mulesoft.apb.project.client.scala.model.report

import amf.core.client.scala.model.domain.AmfObject
import amf.core.client.scala.validation.AMFValidationResult
import amf.core.internal.annotations.LexicalInformation

class APBResult(
    message: String,
    severityLevel: String,
    targetNodeValue: Either[AmfObject, String],
    targetProperty: Option[String], // TODO: is it used??
    validationId: String,
    position: Option[LexicalInformation],
    location: Option[String],
    source: Any,
    val aspect: ProjectAspect
) extends AMFValidationResult(
      message,
      severityLevel,
      targetNodeValue,
      targetProperty,
      validationId,
      position,
      location,
      source
    ) {}

object APBResult {
  def apply(
      message: String,
      severityLevel: String,
      targetNodeValue: String,
      targetProperty: Option[String], // TODO: is it used??
      validationId: String,
      position: Option[LexicalInformation],
      location: Option[String],
      source: Any,
      aspect: ProjectAspect
  ) = new APBResult(
    message,
    severityLevel,
    Right(targetNodeValue),
    targetProperty,
    validationId,
    position,
    location,
    source,
    aspect
  )

  def forAspect(result: AMFValidationResult, aspect: ProjectAspect): APBResult =
    APBResult(
      result.message,
      result.severityLevel,
      result.targetNode,
      result.targetProperty,
      result.validationId,
      result.position,
      result.location,
      result.source,
      aspect
    )

  def forContract(result: AMFValidationResult): APBResult = forAspect(result, ProjectAspects.CONTRACT)

  def forGlobal(result: AMFValidationResult): APBResult = forAspect(result, ProjectAspects.GLOBAL)

  def forRuntime(result: AMFValidationResult): APBResult = forAspect(result, ProjectAspects.RUNTIME)

}
