package org.mulesoft.apb.project.client.scala.parser

import amf.apb.internal.parser.APBConfiguration.Project
import amf.apicontract.client.scala.AMFBaseUnitClient
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.model.project.ProjectInfo

import scala.concurrent.{ExecutionContext, Future}

class ApiSummaryJsonLdPartialParser(resourceLoaders: List[ResourceLoader])(implicit
    val executionContext: ExecutionContext
) {

  private val client: AMFBaseUnitClient = Project()
    .withResourceLoaders(resourceLoaders)
    .baseUnitClient()

  def parse(uri: String): Future[ProjectInfo] = for {
    result <- client.parseDocument(uri)
  } yield {
    result.document.encodes.asInstanceOf[ProjectInfo]
  }

}
