package org.mulesoft.apb.project.internal.instances

import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.{ENVIRONMENT_TARGET_REF, NAME}
import org.mulesoft.apb.project.client.scala.model.project.management.{APIInstance, Environment, EnvironmentBinding}

case class EnvironmentIndex(
    private val byTargetRef: Map[String, EnvironmentBinding],
    private val environments: Map[String, Environment]
) {
  def getEnvironmentFor(instance: APIInstance): Option[(Environment, EnvironmentBinding)] = {
    for {
      binding   <- getBindingForInstanceName(instance.name)
      envTarget <- getEnvironmentTarget(binding)
      env       <- getEnvironment(envTarget)
    } yield {
      (env, binding)
    }
  }

  private def getEnvironment(name: String): Option[Environment] = environments.get(name)

  private def getBindingForInstanceName(name: String): Option[EnvironmentBinding] = byTargetRef.get(name)

  private def getEnvironmentTarget(binding: EnvironmentBinding) = {
    binding.specIfPresent
      .flatMap(_.getObjectIfPresent(ENVIRONMENT_TARGET_REF))
      .flatMap(_.getScalarIfPresent[String](NAME))
  }
}

object EnvironmentIndex {
  def build(catalog: ResourceCatalog): EnvironmentIndex = {
    EnvironmentIndex(
        catalog.getEnvironmentBindings.flatMap(eb => eb.getTargetRefName.map(name => name -> eb)).toMap,
        catalog.getEnvironments.map(env => env.name -> env).toMap
    )
  }
}
