package org.mulesoft.apb.project.client.scala.model.descriptor

import amf.core.client.scala.model.{BoolField, StrField}
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel.{
  AssetId,
  Classifier,
  GroupId,
  Packaging,
  Provided,
  Scope,
  Version,
  entityModel
}
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}

import scala.language.implicitConversions

case class ProjectDependency private[apb] (override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = ProjectDependency

  override protected def fields: Fields = internal.fields

  private implicit def scopeToDependencyScope(strField: StrField): DependencyScope =
    strField.option().map(DependencyScope.apply).getOrElse(DesignScope)

  def gav: Gav = Gav(groupId, assetId, version)

  def groupId: String = get[StrField](GroupId)

  def assetId: String = get[StrField](AssetId)

  def version: String = get[StrField](Version)

  def hasExplicitScope: Boolean = {
    val value: StrField = get[StrField](Scope)
    value.option().isDefined
  }

  def shouldBeProvided: Boolean = get[BoolField](Provided)

  def scope: DependencyScope = get[StrField](Scope)

  def classifier: Option[String] = get[StrField](Classifier)

  def packaging: Option[String] = get[StrField](Packaging)

  def absolutePath: String = "/exchange_modules/" + gav.path + "exchange.json"

  def withScope(scope: DependencyScope): ProjectDependency = {
    internal.withProperty(Scope, scope.scope)
    this
  }

  def withProvided(provided: Boolean): ProjectDependency = {
    internal.withProperty(Provided, provided)
    this
  }

  def withClassifier(classifier: String): ProjectDependency = {
    internal.withProperty(Classifier, classifier)
    this
  }

  def withPackaging(packaging: String): ProjectDependency = {
    internal.withProperty(Packaging, packaging)
    this
  }

}

object ProjectDependency {
  def apply(gav: Gav): ProjectDependency = {
    val dObject = JsonLDObject
      .empty(entityModel, JsonPath.empty)
      .set(GroupId, gav.groupId)
      .set(AssetId, gav.assetId)
      .set(Version, gav.version)
    ProjectDependency(dObject)
  }
}
