package org.mulesoft.apb.project.client.platform.model.descriptor.community

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{PortalTarget => InternalPortalTarget}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class PortalTarget private[apb] (override private[apb] val _internal: InternalPortalTarget)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("PortalTarget")
  def this(network: String, organization: String, domain: String, environment: String) =
    this(InternalPortalTarget(network, organization, domain, environment))

  def network(): String      = _internal.network
  def organization(): String = _internal.organization
  def domain(): String       = _internal.domain
  def environment(): String  = _internal.environment

  def withNetwork(network: String): PortalTarget = {
    _internal.withNetwork(network)
    this
  }
  def withOrganization(organization: String): PortalTarget = {
    _internal.withOrganization(organization)
    this
  }
  def withDomain(domain: String): PortalTarget = {
    _internal.withDomain(domain)
    this
  }
  def withEnvironment(environment: String): PortalTarget = {
    _internal.withEnvironment(environment)
    this
  }
}
