package org.mulesoft.apb.project.client.scala.model.descriptor.governance

import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.metamodel.{Field, Type}
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.{JsonLDElementModel, JsonLDEntityModel}
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.ValidationGroupModel.entityModel
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Governance
import org.mulesoft.apb.project.internal.jsonld.JsonLDPathGenerator
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}
import ValidationGroupModel.{Error, Fail, Pass, Pending}
import org.mulesoft.apb.project.internal.jsonld.JsonLDPathGenerator.jsonLDObjectSeqPath

class ValidationGroup(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = ValidationGroup

  override protected def fields: Fields = internal.fields

  def pass: Seq[Validation]    = get[Seq[JsonLDObject]](Pass).map(Validation.apply)
  def fail: Seq[Validation]    = get[Seq[JsonLDObject]](Fail).map(Validation.apply)
  def error: Seq[Validation]   = get[Seq[JsonLDObject]](Error).map(Validation.apply)
  def pending: Seq[Validation] = get[Seq[JsonLDObject]](Pending).map(Validation.apply)

  def withPass(validation: Seq[Validation]): this.type = {
    val validationSeq = jsonLDObjectSeqPath(validation.map(_.internal), Pass)
    internal.withObjPropertyCollection(Pass, validationSeq)
    this
  }

  def withFail(validation: Seq[Validation]): this.type = {
    val validationSeq = jsonLDObjectSeqPath(validation.map(_.internal), Fail)
    internal.withObjPropertyCollection(Fail, validationSeq)
    this
  }

  def withError(validation: Seq[Validation]): this.type = {
    val validationSeq = jsonLDObjectSeqPath(validation.map(_.internal), Error)
    internal.withObjPropertyCollection(Error, validationSeq)
    this
  }

  def withPending(validation: Seq[Validation]): this.type = {
    val validationSeq = jsonLDObjectSeqPath(validation.map(_.internal), Pending)
    internal.withObjPropertyCollection(Pending, validationSeq)
    this
  }

}

object ValidationGroup {
  def apply(
      pass: Seq[Validation],
      fail: Seq[Validation],
      error: Seq[Validation],
      pending: Seq[Validation]
  ): ValidationGroup =
    ValidationGroup
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withPass(pass)
      .withFail(fail)
      .withError(error)
      .withPending(pending)

  private[apb] def apply(jsonLDObject: JsonLDObject): ValidationGroup = new ValidationGroup(jsonLDObject)
}

trait ValidationGroupModel {
  val Pass: Field    = Field(Type.Array(JsonLDElementModel), Governance + "pass", doc("pass"))
  val Fail: Field    = Field(Type.Array(JsonLDElementModel), Governance + "fail", doc("fail"))
  val Error: Field   = Field(Type.Array(JsonLDElementModel), Governance + "error", doc("error"))
  val Pending: Field = Field(Type.Array(JsonLDElementModel), Governance + "pending", doc("pending"))

  val `type`: List[ValueType] = List(Governance + "ValidationGroup")
  val fields: List[Field]     = List(Pass, Fail, Error, Pending)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)

  protected def doc(name: String) = ModelDoc(displayName = name)
}
object ValidationGroupModel extends ValidationGroupModel
