package org.mulesoft.apb.project.internal.engine

import amf.core.client.common.validation.SeverityLevels
import amf.core.client.scala.validation.AMFValidationResult
import org.mulesoft.apb.project.client.scala.model.descriptor.Gav
import org.mulesoft.apb.project.client.scala.model.report.{APBResult, ProjectAspect, ProjectAspects}
import org.mulesoft.apb.project.internal.validations.ProjectValidations.ProjectMigrationRedundancyRisk

object MigrationRiskValidations {

  def create(risks: MigrationRisks, root: Option[Gav] = None): List[APBResult] = {
    risks.allMigrationRiskDetections.map { case (path, otherRisks) =>
      val firstDetectedGav  = risks.firstMigrationRiskDetection(path)
      val gavList: Set[Gav] = Set(firstDetectedGav) ++ otherRisks
      val detectedForRoot   = root.exists(gav => gavList.contains(gav))
      val gavsToReport      = root.map(gav => gavList.filter(x => x != gav)).getOrElse(gavList)
      APBResult(
          message(path, gavsToReport, firstDetectedGav.path(), detectedForRoot),
          SeverityLevels.VIOLATION,
          "",
          None,
          ProjectMigrationRedundancyRisk.id,
          None,
          Some(firstDetectedGav.path()),
          Unit,
          ProjectAspects.TREE
      )
    }.toList
  }

  private def message(path: String, gavs: Set[Gav], currentGav: String, detectedForRoot: Boolean): String = {
    val initialMessage =
      s"""Detected a possible file collision for files in path $path
         |Please analyze the contents and preserve the most up to date file in the asset with the asset identifier $currentGav
         |Delete the files in the modules that do not reference that file.\n""".stripMargin
    val gavList         = gavs.map(x => s"- Project: ${x.path}").mkString("\n")
    val rootProjectItem = if (detectedForRoot) s"\n- Project: current" else ""
    initialMessage + gavList + rootProjectItem
  }
}
