package org.mulesoft.apb.project.internal.model

import org.mulesoft.apb.project.client.scala.model.descriptor.InstanceModel
import org.mulesoft.apb.project.internal.model.descriptor.{MetadataModel, ProjectDependencyModel}

object ProjectDescriptorModelIris {
  val Main: String                  = ProjectDescriptorModel.Main.value.iri()
  val Name: String                  = ProjectDescriptorModel.Name.value.iri()
  val Classifier: String            = ProjectDependencyModel.Classifier.value.iri()
  val GroupId: String               = ProjectDependencyModel.GroupId.value.iri()
  val AssetId: String               = ProjectDependencyModel.AssetId.value.iri()
  val Version: String               = ProjectDependencyModel.Version.value.iri()
  val ApiVersion: String            = ProjectDescriptorModel.ApiVersion.value.iri()
  val OrganizationId: String        = ProjectDescriptorModel.OrganizationId.value.iri()
  val OriginalFormatVersion: String = ProjectDescriptorModel.OriginalFormatVersion.value.iri()
  val BackwardsCompatible: String   = ProjectDescriptorModel.BackwardsCompatible.value.iri()
  val PublishWithRefFiles: String   = ProjectDescriptorModel.PublishWithRefFiles.value.iri()
  val Description: String           = ProjectDescriptorModel.Description.value.iri()
  val DescriptorVersion: String     = ProjectDescriptorModel.DescriptorVersion.value.iri()

  val Metadata: String  = ProjectDescriptorModel.Metadata.value.iri()
  val BranchId: String  = MetadataModel.BranchId.value.iri()
  val CommitId: String  = MetadataModel.CommitId.value.iri()
  val ProjectId: String = MetadataModel.ProjectId.value.iri()

  val Dependencies: String = ProjectDescriptorModel.Dependencies.value.iri()
  val Tags: String         = ProjectDescriptorModel.Tags.value.iri()

  val ApiInstances: String = ProjectDescriptorModel.ApiInstances.value.iri()
  val GCL: String          = InstanceModel.GCL.value.iri()
  val DefinedBy: String    = InstanceModel.DefinedBy.value.iri()
}
