package org.mulesoft.apb.project.client.platform.model.project.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.{APIInstance => InternalAPIInstance}
import org.mulesoft.apb.project.internal.convert.ManagementClientConverters._
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class APIInstance(override private[apb] val internal: InternalAPIInstance)
    extends DynamicObject(internal)
    with HasName
    with HasAnnotations
    with HasLabels {

  @JSExportTopLevel("APIInstance")
  def this(name: String, address: String) = this(InternalAPIInstance(name, address))

  def address(): String = internal.address

  def withAddress(address: String): this.type = {
    internal.withAddress(address)
    this
  }

  def policyBindings(): ClientList[PolicyBinding] = internal.policyBindings.asClient

  def withPolicyBinding(): PolicyBinding = internal.withPolicyBinding()

  def services(): ClientList[Service] = internal.services.asClient

  def withService(name: String, address: String): Service = internal.withService(name, address)

  def environment(): Environment = internal.environment

  def withEnvironment(name: String): Environment = internal.withEnvironment(name)

  def withEnvironmentId(envId: String): this.type = {
    internal.withEnvironmentId(envId)
    this
  }

  def withInstanceId(id: Int): this.type = {
    internal.withInstanceId(id)
    this
  }

  def withInstanceLabel(label: String): this.type = {
    internal.withInstanceLabel(label)
    this
  }

  def withConsumerEndpoint(endpoint: String): this.type = {
    internal.withConsumerEndpoint(endpoint)
    this
  }

  def hasApprovedContracts(): internal.type =
    internal.withApprovedContracts(true)

  def withApprovedContracts(hasApprovedContracts: Boolean): this.type = {
    internal.withApprovedContracts(hasApprovedContracts)
    this
  }
}
