package org.mulesoft.apb.project.client.scala.model.descriptor.community

import amf.core.client.scala.model.StrField
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.{Int, Str}
import amf.core.internal.metamodel.domain.ModelDoc
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.CommunityProfileModel.{Id, Kind, entityModel}
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.ApiCommunity
import org.mulesoft.apb.project.internal.model.{GraphAccessors, UnwrappedFields}

class CommunityProfile(override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {
  override type This = CommunityProfile

  override protected def fields: Fields = internal.fields

  def id: String   = get[StrField](Id)
  def kind: String = get[StrField](Kind)

  def withId(id: String): this.type = {
    internal.withProperty(Id, id)
    this
  }

  def withKind(kind: String): this.type = {
    internal.withProperty(Kind, kind)
    this
  }
}

object CommunityProfile {
  def apply(id: String, kind: String): CommunityProfile =
    CommunityProfile
      .apply(JsonLDObject.empty(entityModel, JsonPath.empty))
      .withId(id)
      .withKind(kind)

  private[apb] def apply(jsonLDObject: JsonLDObject): CommunityProfile = new CommunityProfile(jsonLDObject)
}

trait CommunityProfileModel {
  val Id: Field = Field(Str, ApiCommunity + "id", doc("id"))

  val Kind: Field = Field(Str, ApiCommunity + "kind", doc("kind"))

  def `type`: List[ValueType] = List(ApiCommunity + "CommunityProfile")
  def fields: List[Field]     = List(Id, Kind)

  protected def doc(name: String) = ModelDoc(displayName = name)

  val entityModel: JsonLDEntityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}

object CommunityProfileModel extends CommunityProfileModel
