package org.mulesoft.apb.project.internal.parser

import amf.core.client.scala.adoption.IdAdopter
import amf.core.client.scala.model.domain.AmfObject
import amf.core.client.scala.validation.AMFValidationResult
import amf.shapes.client.scala.config.JsonSchemaConfiguration
import amf.shapes.client.scala.model.document.{JsonLDInstanceDocument, JsonSchemaDocument}
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.spec.jsonldschema.JsonLDSchemaParsePlugin
import org.mulesoft.apb.project.internal.parser.SyncJsonSchemaCompiler.{context, parseJson}

object SyncJsonLdSchemaParser {

  def parse(doc: JsonSchemaDocument, payload: String): (JsonLDObject, Seq[AMFValidationResult]) = {
    val ctx    = context(JsonSchemaConfiguration.JsonSchema())
    val ast    = parseJson(payload, ctx.eh)
    val plugin = new JsonLDSchemaParsePlugin(doc)
    val parsed = plugin.parse(ast, ctx).asInstanceOf[JsonLDInstanceDocument].encodes.head.asInstanceOf[JsonLDObject]
    (adopt(parsed), ctx.eh.getResults)
  }

  private def adopt[T <: AmfObject](obj: T): T = {
    new IdAdopter("root").adoptFromRoot(obj)
    obj
  }
}
