package org.mulesoft.apb.project.client.platform.model.descriptor.governance

import amf.core.internal.convert.CoreClientConverters.ClientList
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{ValidationGroup => InternalValidationGroup}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class ValidationGroup private[apb] (override private[apb] val _internal: InternalValidationGroup)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("ValidationGroup")
  def this(
      pass: ClientList[Validation],
      fail: ClientList[Validation],
      error: ClientList[Validation],
      pending: ClientList[Validation]
  ) =
    this(InternalValidationGroup(pass.asInternal, fail.asInternal, error.asInternal, pending.asInternal))

  def pass(): ClientList[Validation]    = _internal.pass.asClient
  def fail(): ClientList[Validation]    = _internal.fail.asClient
  def error(): ClientList[Validation]   = _internal.error.asClient
  def pending(): ClientList[Validation] = _internal.pending.asClient

  def withPass(pass: ClientList[Validation]): ValidationGroup = {
    _internal.withPass(pass.asInternal)
    this
  }

  def withFail(fail: ClientList[Validation]): ValidationGroup = {
    _internal.withFail(fail.asInternal)
    this
  }

  def withError(error: ClientList[Validation]): ValidationGroup = {
    _internal.withError(error.asInternal)
    this
  }
  def withPending(pending: ClientList[Validation]): ValidationGroup = {
    _internal.withPending(pending.asInternal)
    this
  }

}
