package org.mulesoft.apb.project.client.platform.model.report

import amf.core.internal.annotations.LexicalInformation
import amf.core.internal.convert.CoreClientConverters.ClientOption
import org.mulesoft.apb.project.client.scala.model.report.ProjectAspect
import org.mulesoft.common.client.lexical.PositionRange
import org.mulesoft.apb.project.client.scala.model.report.{APBResult => InternalAPBResult}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import amf.core.internal.utils.AmfStrings

@JSExportAll
class APBResult(private[apb] val _internal: InternalAPBResult) {

  @JSExportTopLevel("APBResult")
  def this(
      message: String,
      level: String,
      targetNode: String,
      targetProperty: String,
      validationId: String,
      range: PositionRange,
      location: String,
      aspect: ProjectAspect
  ) =
    this(
      new InternalAPBResult(
        message,
        level,
        Right(targetNode),
        targetProperty.option,
        validationId,
        Some(LexicalInformation(range)),
        location.option,
        null,
        aspect
      )
    )

  def message: String = _internal.message

  def severityLevel: String = _internal.severityLevel

  def targetNode: String = _internal.targetNode

  def targetProperty: String = _internal.targetProperty.orNull

  def validationId: String = _internal.validationId

  def source: Any = _internal.source

  def position: PositionRange = _internal.position match {
    case Some(lexical) => lexical.range
    case _             => PositionRange.NONE
  }

  def location: ClientOption[String] = _internal.location.asClient

  def aspect: ProjectAspect = _internal.aspect
}
