package org.mulesoft.apb.project.internal.emitter.governance

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{ValidationGroup, ValidationGroupModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitJsonLdObjectArray
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryValidationGroupEmitter(validationGroup: ValidationGroup) extends PartEmitter {

  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitJsonLdObjectArray(entryBuilder, validationGroup, ValidationGroupModel.Pass) { validation =>
        ProjectSummaryValidationEmitter(validation)
      }
      emitJsonLdObjectArray(entryBuilder, validationGroup, ValidationGroupModel.Pending) { validation =>
        ProjectSummaryValidationEmitter(validation)
      }
      emitJsonLdObjectArray(entryBuilder, validationGroup, ValidationGroupModel.Fail) { validation =>
        ProjectSummaryValidationEmitter(validation)
      }
      emitJsonLdObjectArray(entryBuilder, validationGroup, ValidationGroupModel.Error) { validation =>
        ProjectSummaryValidationEmitter(validation)
      }
    }
  }
  override def position(): Position = Position.ZERO
}

object ProjectSummaryValidationGroupEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryValidationGroupEmitter(ValidationGroup(instance))
}
