package org.mulesoft.apb.project.internal.idadoption

object URITools {

  implicit class URIStr(str: String) {
    object Protocols {
      val FILE  = "file://"
      val HTTP  = "http://"
      val HTTPS = "https://"
      val URN   = "urn"
    }

    private def isFile = str.startsWith(Protocols.FILE)
    private def isHTTP = str.startsWith(Protocols.HTTP)

    private def isHTTPs = str.startsWith(Protocols.HTTPS)

    private def isURN        = str.startsWith(Protocols.URN)
    def hasProtocol: Boolean = isFile || isHTTP || isHTTPs || isURN

    def addProtocol: String  = "file://" + str
    def withProtocol: String = if (hasProtocol) str else addProtocol

    def fromPath: String = withProtocol.withFragment

    def withFragment: String                      = if (str.endsWith("#")) str else str + "#"
    def indexed(index: Int, kind: String): String = withSufix(kind + "/" + index)

    def stripProtocol: String = {
      if (isFile) str.stripPrefix(Protocols.FILE)
      else if (isHTTP) str.stripPrefix(Protocols.HTTP)
      else if (isHTTPs) str.stripPrefix(Protocols.HTTPS)
      else if (isURN) str.stripPrefix(Protocols.URN)
      else str
    }

    private def sufixWithExtension(sufix: String) = {
      val extension = str.substring(str.lastIndexOf("."))
      str.stripSuffix(extension) + "/" + sufix + extension
    }

    def forKind(kind: String): String = withSufix(kind)

    private def withSufix(sufix: String) = {
      if (str.contains(".")) sufixWithExtension(sufix)
      else str + "/" + sufix
    }
  }
}
