package org.mulesoft.apb.project.internal.view

import amf.core.client.scala.model.domain.{AmfArray, AmfElement, AmfObject, DomainElement}
import amf.core.internal.metamodel.Field
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.internal.view.Views.View

trait ModelView[T] {
  def view(element: AmfObject): T
}

case class CustomizableModelView(views: List[View], copier: AmfObjectElementCopier) extends ModelView[AmfObject] {

  private def filters = views.toMap

  def view(project: AmfObject): AmfObject = {
    createView(project)
  }

  private def createView(project: AmfObject): AmfObject = {
    val summary = copier.copy(project)
    createView(project, summary)
  }

  private def createView[T <: AmfObject](origin: AmfObject, view: T): T = {
    val fields = fieldViewsFor(origin)
    fields.foldLeft(view) { (result, field) =>
      find(origin, field)
        .map { value =>
          val next = traverse(value, shallowCopy(value))
          result.setWithoutId(field, next)
        }
        .getOrElse(result)
    }
  }

  private def fieldViewsFor[T <: AmfObject](origin: AmfObject) = {
    origin.meta.`type`.flatMap(filters.get).flatten
  }

  private def shallowCopy(element: AmfElement): AmfElement = element match {
    case obj: AmfObject  => copier.copy(obj)
    case array: AmfArray => AmfArray(array.values.map(x => shallowCopy(x)))
    case other           => other
  }

  private def traverse(origin: AmfElement, view: AmfElement): AmfElement = {
    (origin, view) match {
      case (originObj: AmfObject, viewObj: AmfObject) => createView(originObj, viewObj)
      case (originArr: AmfArray, viewArr: AmfArray) =>
        originArr.values.zip(viewArr.values).foreach(traverse)
        viewArr
      case _ => view
    }
  }

  private def traverse(tuple: (AmfElement, AmfElement)): AmfElement = traverse(tuple._1, tuple._2)

  private def find(element: AmfObject, field: Field) = {
    element.fields.getValueAsOption(field).map(_.value)
  }
}
