package org.mulesoft.apb.project.internal.view

import amf.aml.internal.metamodel.document.DialectInstanceModel.DefinedBy
import amf.core.client.scala.vocabulary.{Namespace, ValueType}
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.document.DocumentModel
import org.mulesoft.apb.project.client.scala.extensions.EnvironmentExtension.ENVIRONMENT_IRI
import org.mulesoft.apb.project.client.scala.model.descriptor.{InstanceModel, community}
import org.mulesoft.apb.project.client.scala.model.descriptor.community.CommunityModel
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.DocumentationModel
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{
  GovernanceInfoModel,
  StatusModel,
  ValidationGroupModel,
  ValidationModel
}
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris
import org.mulesoft.apb.project.client.scala.model.project.management.SchemaIris.RichString
import org.mulesoft.apb.project.internal.extensions.environment.InstanceEnvironmentModel
import org.mulesoft.apb.project.internal.instances.APIInstanceModel.API_INSTANCE_TERM
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel
import org.mulesoft.apb.project.internal.metamodel.ProjectInfoModel.Instances
import org.mulesoft.apb.project.internal.model.ProjectDescriptorModel
import org.mulesoft.apb.project.internal.model.ProjectDescriptorModel._
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel._
import org.mulesoft.apb.project.internal.model.project.ProjectDocumentBuilder.INSTANCE_ID_IRI

object Views {

  type View = (ValueType, List[Field])

  private val projectView = ProjectInfoModel.`type`.head -> List(
      OrganizationId,
      Classifier,
      GroupId,
      AssetId,
      Version,
      MajorVersionComponent,
      MinorVersionComponent,
      PatchVersionComponent,
      Status,
      Tags,
      Categories,
      Instances,
      Dependencies,
      TenantId,
      CreatedAt,
      CreatedBy,
      UpdatedAt,
      TypeField,
      Name,
      ApiVersion,
      ApiId,
      ProjectType,
      ContactName,
      ContactEMail,
      Communities,
      Description,
      SystemUpdatedAt,
      ProjectETag,
      GovernanceInfo,
      HasDocumentation,
      Documentation,
      ApiUrn
      //      Contract
  )

  private val apiContractView = DocumentModel.`type`.head -> List(
      DefinedBy
  )

  private val apiInstanceView = API_INSTANCE_TERM -> List(
      INSTANCE_ID_IRI,
      ENVIRONMENT_IRI,
      SchemaIris.METADATA.toObjField
  )

  private val metadataView: (ValueType, List[Field]) =
    SchemaIris.METADATA.toValueType -> List(SchemaIris.LABELS.toObjField)

  private val labelsView = SchemaIris.LABELS.toValueType -> List(
      SchemaIris.API_INSTANCE_ID_LABEL.toIntField,
      SchemaIris.API_INSTANCE_LABEL_LABEL.toStrField,
      SchemaIris.API_INSTANCE_LABEL_LABEL.toStrField,
      SchemaIris.API_INSTANCE_CONSUMER_ENDPOINT_LABEL.toStrField,
      SchemaIris.API_INSTANCE_HAS_APPROVED_CONTRACTS_LABEL.toBoolField
  )

  private val dependencyView: (ValueType, List[Field]) = ProjectDependencyModel.`type`.head -> List(
      GroupId,
      AssetId,
      Version,
      Scope
  )

  private val communityView: (ValueType, List[Field]) =
    CommunityModel.`type`.head -> CommunityModel.fields

  private val governanceInfoView: (ValueType, List[Field]) =
    GovernanceInfoModel.`type`.head -> GovernanceInfoModel.fields

  private val validationGroupView: (ValueType, List[Field]) =
    ValidationGroupModel.`type`.head -> ValidationGroupModel.fields

  private val validationView: (ValueType, List[Field]) =
    ValidationModel.`type`.head -> ValidationModel.fields

  private val statusView: (ValueType, List[Field]) =
    StatusModel.`type`.head -> StatusModel.fields

  private val environmentView: (ValueType, List[Field]) =
    InstanceEnvironmentModel.`type`.head -> InstanceEnvironmentModel.fields

  private val instancesDescriptorView = InstanceModel.`type`.head -> InstanceModel.fields

  private val documentationView: (ValueType, List[Field]) =
    DocumentationModel.`type`.head -> DocumentationModel.fields

  val projectSummary: List[View] =
    //    List(projectView, apiContractView, apiInstanceView, environmentView, dependencyView, metadataView, labelsView)
    List(
        projectView,
        apiInstanceView,
        environmentView,
        dependencyView,
        metadataView,
        labelsView,
        communityView,
        governanceInfoView,
        validationGroupView,
        validationView,
        statusView,
        documentationView
    )

  private val descriptorFieldsView: (ValueType, List[Field]) =
    ProjectDescriptorModel.`type`.head -> ProjectInfoModel.fields.filterNot(f =>
      List(Instances, Documentation, Communities).contains(f)
    )

  val descriptorView: List[View] =
    List(
        descriptorFieldsView,
        dependencyView,
        instancesDescriptorView,
        labelsView,
        metadataView,
        communityView,
        governanceInfoView,
        documentationView
    )

  def mappings(schemaId: String) = {

    def valueType = (entity: String) => ValueType(Namespace(schemaId), s"#/declarations/${entity}")

    Map(
        ProjectInfoModel.`type`.head         -> List(valueType("APIProject")),
        InstanceEnvironmentModel.`type`.head -> List(valueType("Environment")),
        ProjectDependencyModel.`type`.head   -> List(valueType("Dependency")),
        API_INSTANCE_TERM                    -> List(valueType("APIInstance")),
        DocumentModel.`type`.head            -> List(valueType("Document")),
        CommunityModel.`type`.head           -> List(valueType("Community")),
        GovernanceInfoModel.`type`.head      -> List(valueType("GovernanceInfo")),
        DocumentationModel.`type`.head       -> List(valueType("Documentation"))
    )
  }
}
