package org.mulesoft.apb.project.internal.transformation

import amf.core.client.scala.AMFGraphConfiguration
import amf.core.client.scala.errorhandling.AMFErrorHandler
import amf.core.client.scala.model.document.{BaseUnit, FieldsFilter}
import amf.core.client.scala.model.domain.ExternalSourceElement
import amf.core.client.scala.transform.TransformationStep
import amf.core.client.scala.traversal.iterator.InstanceCollector
import amf.core.internal.adoption.AdoptionDependantCalls
import amf.core.internal.metamodel.domain.ExternalSourceElementModel

/** This stage is to hack a problem: There is an optimization in AMF, to reduce the size of the JSON-LD, that puts in
  * some cases the ID of a referenced file under the field ReferenceId. Instead of emitting all the content again, it
  * emits "link" in the JSON-LD. The problem is that APB generated multiple clones and re-adoptions. In those cases the
  * ID in this field remains unchanged and there are some cases where the function inside AdoptionDependantCalls keep
  * pointing to the old instance, which is not readopted. In those cases the link in the JSON-LD is broken. The fix
  * should be in AMF but it is complex an quite a sensitive part of the code.
  */
class AdoptionDependantCallsFixingTransformationStage() extends TransformationStep() {

  override def transform(
      model: BaseUnit,
      errorHandler: AMFErrorHandler,
      configuration: AMFGraphConfiguration
  ): BaseUnit = {
    model
      .iterator(fieldsFilter = FieldsFilter.All, visited = InstanceCollector())
      .foreach {
        case externalRef: ExternalSourceElement with AdoptionDependantCalls
            if externalRef.fields.exists(ExternalSourceElementModel.ReferenceId) =>
          externalRef.fields.removeField(ExternalSourceElementModel.ReferenceId)
        case _ => // Nothing to do
      }
    model
  }

}
