package org.mulesoft.apb.project.client.scala.model.descriptor

import amf.core.client.scala.model.StrField
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import AttributeEntryModel._
import amf.core.client.scala.vocabulary.Namespace.Data
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Catalog
import org.mulesoft.apb.project.internal.model.{GraphAccessors, StringTupleValue, UnwrappedFields}

import scala.language.implicitConversions

case class AttributeEntry private[apb] (override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = AttributeEntry

  override protected def fields: Fields = internal.fields

  def key: String = get[StrField](Key)

  def value: String = get[StrField](Value)

  def tuple: String = StringTupleValue.value(key, value)

  def withKey(key: String): AttributeEntry = {
    internal.withProperty(Key, key)
    this
  }

  def withValue(value: String): AttributeEntry = {
    internal.withProperty(Value, value)
    this
  }
}

object AttributeEntry {
  def apply(key: String, value: String): AttributeEntry = {
    val internal = JsonLDObject
      .empty(entityModel, JsonPath.empty)
      .set(Key, key)
      .set(Value, value)

    AttributeEntry(internal)
  }
}

object AttributeEntryModel {

  val Key   = Field(Str, Data + "key", doc("key"))
  val Value = Field(Str, Data + "value", doc("value"))

  val `type`: List[ValueType] = List(Catalog + "AttributeEntry")

  private def doc(name: String) = ModelDoc(displayName = name)

  val fields: List[Field] = List(Key, Value)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}
