package org.mulesoft.apb.project.internal.dependency

import org.mulesoft.apb.project.client.scala.model.descriptor.Gav

case class CyclicProjectDependencyException(current: Gav, dependenciesInPath: Set[Gav]) extends Exception {
  override def getMessage: String = {
    s"""Encountered unrecoverable cycle between dependencies while parsing: ${current.path}
       |Parsing path: $seenDepsAsString""".stripMargin
  }

  private def seenDepsAsString: String = dependenciesInPath.map(_.path).mkString("\n")
}
