package org.mulesoft.apb.project.internal.emitter

import amf.apicontract.internal.metamodel.domain.api.WebApiModel
import amf.core.client.scala.model.document.{BaseUnit, Document}
import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.document.JsonLDInstanceDocument
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitScalarField
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryDocumentContractEmitter(contractDocument: Document) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    val contract = contractDocument.encodes

    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, contract, WebApiModel.Name)
    }
  }

  override def position(): Position = Position.ZERO
}
class ProjectSummaryJsonLdDocumentContractEmitter(contractDocument: JsonLDInstanceDocument) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { _ => }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryContractEmitter {
  def apply(contractDocument: BaseUnit) = contractDocument match {
    case document: Document => new ProjectSummaryDocumentContractEmitter(document)
    case jsonLdDocument: JsonLDInstanceDocument => new ProjectSummaryJsonLdDocumentContractEmitter(jsonLdDocument)
  }
}
