package org.mulesoft.apb.project.internal.model.descriptor

import amf.core.client.scala.vocabulary.Namespace.{Core, Data}
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath

object MetadataModel {

  val BranchId  = Field(Str, Data + "branchId", doc("branchId"))
  val CommitId  = Field(Str, Data + "commitId", doc("commitId"))
  val ProjectId = Field(Str, Data + "projectId", doc("projectId"))
  val Variables = Field(Str, Core + "variables", doc("variables"))

  val `type`: List[ValueType] = List(Data + "Metadata")
  val fields: List[Field]     = List(BranchId, CommitId, ProjectId)

  private def doc(name: String) = ModelDoc(displayName = name)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)
}
