package org.mulesoft.apb.project.client.platform.model.descriptor

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.{
  DependencyScope,
  ProjectDependency => InternalProjectDependency
}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
case class ProjectDependency private[apb] (override private[apb] val _internal: InternalProjectDependency)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("ProjectDependency")
  def this(gav: Gav) = this(InternalProjectDependency(gav._internal))

  def gav(): Gav                  = GavMatcher.asClient(_internal.gav)
  def scope(): DependencyScope    = _internal.scope
  def hasExplicitScope(): Boolean = _internal.hasExplicitScope
  def shouldBeProvided(): Boolean = _internal.shouldBeProvided
  def classifier(): ClientOption[String] = _internal.classifier.asClient
  def packaging(): ClientOption[String] = _internal.packaging.asClient

  def absolutePath(): String = _internal.absolutePath

  def withScope(scope: DependencyScope): ProjectDependency = _internal.withScope(scope)

  def withProvided(provided: Boolean): ProjectDependency = _internal.withProvided(provided)

  def withClassifier(classifier: String): ProjectDependency = _internal.withClassifier(classifier)

  def withPackaging(packaging: String): ProjectDependency = _internal.withPackaging(packaging)
}
