package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.{AttributeEntry, AttributeEntryModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.{emitScalarField, emitStringValue}
import org.mulesoft.apb.project.internal.emitter.ProjectSummaryAttributeEntryEmitter.TupleFieldName
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryAttributeEntryEmitter(attribute: AttributeEntry) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, attribute, AttributeEntryModel.Key)
      emitScalarField(entryBuilder, attribute, AttributeEntryModel.Value)
      emitStringValue(entryBuilder, TupleFieldName, attribute.tuple)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryAttributeEntryEmitter {
  val TupleFieldName = "tuple"

  def apply(instance: JsonLDObject) = new ProjectSummaryAttributeEntryEmitter(AttributeEntry(instance))
}
