package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.FilePackaging
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.{emitScalarField, emitStringValue}
import org.mulesoft.apb.project.internal.emitter.ProjectSummaryFilePackagingEmitter.TupleFieldName
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryFilePackagingEmitter(filePackaging: FilePackaging) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, filePackaging, ProjectDependencyModel.Packaging)
      emitScalarField(entryBuilder, filePackaging, ProjectDependencyModel.Classifier)
      emitStringValue(entryBuilder, TupleFieldName, filePackaging.tuple)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryFilePackagingEmitter {
  val TupleFieldName = "tuple"

  def apply(instance: JsonLDObject) = new ProjectSummaryFilePackagingEmitter(FilePackaging(instance))
}
