package org.mulesoft.apb.project.client.platform.model.project.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.{PolicyBindingRule => InternalPolicyBindingRule}

import scala.scalajs.js.annotation.JSExportAll

@JSExportAll
class PolicyBindingRule(override private[apb] val _internal: InternalPolicyBindingRule)
    extends DynamicObject(_internal) {
  def path: String = _internal.path
  def withPath(path: String): this.type = {
    _internal.withPath(path)
    this
  }
  def method: String = _internal.method
  def withMethod(method: String): this.type = {
    _internal.withMethod(method)
    this
  }
  def host: String = _internal.host
  def withHost(host: String): this.type = {
    _internal.withHost(host)
    this
  }
  def getStringHeader(name: String): String   = _internal.getHeader[String](name)
  def getIntHeader(name: String): Int         = _internal.getHeader[Int](name)
  def getFloatHeader(name: String): Float     = _internal.getHeader[Float](name)
  def getDoubleHeader(name: String): Double   = _internal.getHeader[Double](name)
  def getBooleanHeader(name: String): Boolean = _internal.getHeader[Boolean](name)

  def addHeader(name: String, value: String): this.type = {
    _internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Int): this.type = {
    _internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Float): this.type = {
    _internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Double): this.type = {
    _internal.addHeader(name, value)
    this
  }

  def addHeader(name: String, value: Boolean): this.type = {
    _internal.addHeader(name, value)
    this
  }
}
