package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{CommunityProfile, CommunityProfileModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitScalarField
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryCommunityProfileEmitter(profile: CommunityProfile) extends PartEmitter {
  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, profile, CommunityProfileModel.Id)
      emitScalarField(entryBuilder, profile, CommunityProfileModel.Kind)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryCommunityProfileEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryCommunityProfileEmitter(CommunityProfile(instance))
}
