package org.mulesoft.apb.project.internal.transformation.steps

import org.mulesoft.apb.project.internal.common.Classifier

object AgentNetworkMetadata {

  val BASE = "http://anypoint.com/vocabs/agents#"

  // declarations
  val DECLARATIONS = s"${BASE}DeclarationDefinitions"

  // references
  val REFERENCES = s"${BASE}Reference"

  // kind
  val KIND_BASE         = "http://anypoint.com/vocabs/agents/reference/kind#"
  val AGENT_SUFFIX      = "agent"
  val LLM_SUFFIX        = "llm"
  val MCP_SUFFIX        = "mcp"
  val CONNECTION_SUFFIX = "connection"
  val POLICY_SUFFIX     = "policy"

  // field name where the reference goes
  val NAME = s"${BASE}name"
  // field namespace for the asset references
  val NAMESPACE = s"${BASE}namespace"

  // Returns the allowed target classifiers based on the reference kind
  def refKindToClassifier(kind: String): Seq[String] = kind match {
    case AGENT_SUFFIX      => Seq(Classifier.AGENT_CARD, Classifier.OTHER_CARD, Classifier.AGENT_METADATA)
    case LLM_SUFFIX        => Seq(Classifier.LLM_METADATA)
    case MCP_SUFFIX        => Seq(Classifier.MCP)
    case CONNECTION_SUFFIX => Seq.empty // No remote asset for connection references
    case POLICY_SUFFIX     => Seq(Classifier.POLICY_SCHEMA)
    case _                 => Seq.empty
  }
}
