package org.mulesoft.apb.project.internal.validations

import amf.core.client.common.validation.SeverityLevels.{VIOLATION, WARNING}
import amf.core.internal.validation.core.{ShaclSeverityUris, ValidationSpecification}

object ProjectValidations {

  val UnreacheableAsset: ValidationSpecification = ValidationSpecification("unreachable-asset", s"Unreachable asset")
  val MissingMainFile: ValidationSpecification =
    ValidationSpecification("missing-main-file", "Main File is mandatory for design projects")
  val ScopePresentInLegacyProject: ValidationSpecification =
    ValidationSpecification("scope-present-in-legacy-project", s"Scope present in legacy project")
  val SuggestedExtensionDependency: ValidationSpecification =
    ValidationSpecification("suggested-extension-dependency", s"Suggested extension dependency")
  val ProjectMigrationRedundancyRisk: ValidationSpecification =
    ValidationSpecification("project-migration-redundancy-risk", "Project migration redundancy risk")

  val AbsolutePathUsage: ValidationSpecification = ValidationSpecification(
      "absolute-path",
      "Absolute references starting with '/' are not more allowed"
  )

  val InternalDependencyFileReference: ValidationSpecification = ValidationSpecification(
      "internal-dependency-file-reference",
      "References to non root dependency files is not recommended. Use dependency main file.",
      ShaclSeverityUris.amfToShaclSeverity(WARNING)
  )

  val MissingCompanionLibUses: ValidationSpecification = ValidationSpecification(
      "missing-companion-lib-uses",
      "Cannot declare the Annotation locally."
  )

  val ProjectDescriptorSyntaxError: ValidationSpecification = ValidationSpecification(
      "project-descriptor-syntax-error",
      "Syntax error at project descriptor"
  )

  val ProjectDescriptorModelError: ValidationSpecification = ValidationSpecification(
      "project-descriptor-model-error",
      "Model error at project descriptor"
  )

  val PolicyConfigurationError: ValidationSpecification = ValidationSpecification(
    "policy-configuration-error",
    "Policy config does not conforms the schema policy definition"
  )

  val DependencySetError: ValidationSpecification = ValidationSpecification(
      "dependency-set-error",
      "Error at dependency tree"
  )

  val GCLSyntaxError: ValidationSpecification = ValidationSpecification(
      "gcl-syntax-error",
      "GCL Syntax Error"
  )

}
