package org.mulesoft.apb.project.client.scala.model.descriptor

import amf.core.client.scala.model.StrField
import amf.core.internal.parser.domain.Fields
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.client.scala.model.DynamicObject
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel.{Classifier, Packaging}
import FilePackagingModel.{FileTag, entityModel}
import amf.core.client.scala.vocabulary.ValueType
import amf.core.internal.metamodel.Field
import amf.core.internal.metamodel.Type.Str
import amf.core.internal.metamodel.domain.ModelDoc
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import org.mulesoft.apb.project.internal.descriptor.ApiProjectNamespaces.Catalog
import org.mulesoft.apb.project.internal.model.descriptor.ProjectDependencyModel
import org.mulesoft.apb.project.internal.model.{GraphAccessors, StringTupleValue, UnwrappedFields}

import scala.language.implicitConversions

case class FilePackaging private[apb] (override private[apb] val internal: JsonLDObject)
    extends DynamicObject
    with GraphAccessors
    with UnwrappedFields {

  override type This = FilePackaging

  override protected def fields: Fields = internal.fields

  def packaging: String = get[StrField](Packaging)

  def classifier: String = get[StrField](Classifier)

  def fileTag: String = get[StrField](FileTag)

  def tuple: String = StringTupleValue.value(classifier, packaging)

  def withPackaging(packaging: String): FilePackaging = {
    internal.withProperty(Packaging, packaging)
    this
  }

  def withClassifier(classifier: String): FilePackaging = {
    internal.withProperty(Classifier, classifier)
    this
  }

  def withFileTag(tag: String): FilePackaging = {
      internal.withProperty(FileTag, tag)
      this
  }
}

object FilePackaging {
  def apply(packaging: String, classifier: String, fileTag: String): FilePackaging = {
    val internal = JsonLDObject
      .empty(entityModel, JsonPath.empty)
      .set(Packaging, packaging)
      .set(Classifier, classifier)
      .set(FileTag, fileTag)

    FilePackaging(internal)
  }
}

object FilePackagingModel {
  val `type`: List[ValueType] = List(Catalog + "FilePackaging")

    val FileTag    = Field(Str, Catalog + "fileTag", doc("fileTag"))

  val fields: List[Field] = List(ProjectDependencyModel.Classifier, ProjectDependencyModel.Packaging, FileTag)

  val entityModel = JsonLDEntityModel(`type`, fields, JsonPath.empty)

  private def doc(name: String) = ModelDoc(displayName = name)
}
