package org.mulesoft.apb.project.internal.environment

import amf.core.client.common.remote.Content
import amf.core.client.scala.resource.ResourceLoader
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.model.descriptor.ProjectDependency
import org.mulesoft.apb.project.internal.dependency.ExchangeModulePathHandler
import org.mulesoft.apb.project.internal.parser.APBEnv

import scala.concurrent.{ExecutionContext, Future}

object ExchangePath {
  def apply(dependency: ProjectDependency, resource: String): String =
    ExchangeModulePathHandler.buildPath(dependency, resource, APBEnv.projectProtocol)
}

case class CustomPathDependencyFetcher(fetcher: DependencyFetcher, pathFunc: (ProjectDependency, String) => String)(
    implicit ec: ExecutionContext
) extends DependencyFetcher {
  override def accepts(dependency: ProjectDependency): Boolean = fetcher.accepts(dependency)

  override def fetch(dependency: ProjectDependency): ResourceLoader = {
    val inner = fetcher.fetch(dependency)
    new ResourceLoader {

      /** Fetch specified resource and return associated content. Resource should have been previously accepted. If the
        * resource doesn't exists, it returns a failed future caused by a ResourceNotFound exception.
        */
      override def fetch(resource: String): Future[Content] = {
        inner.fetch(resource).map { c =>
          val path = pathFunc(dependency, resource)
          c.copy(url = path)
        }
      }

      /** Checks if the resource loader accepts the specified resource. */
      override def accepts(resource: String): Boolean = inner.accepts(resource)
    }
  }
}
