package org.mulesoft.apb.project.internal.metamodel

import amf.core.internal.metamodel.ModelDefaultBuilder
import amf.shapes.internal.domain.metamodel.jsonldschema.JsonLDEntityModel
import amf.shapes.internal.spec.jsonldschema.parser.JsonPath
import org.mulesoft.apb.project.internal.instances.APIInstanceModel.API_INSTANCE_TERM

object APBEntities {
  private val innerEntities: Seq[ModelDefaultBuilder] = Seq(
      ProjectDocumentModel,
      ProjectInfoModel,
      JsonLDEntityModel(List(API_INSTANCE_TERM), Nil, JsonPath.empty)
  )

  def entities: Map[String, ModelDefaultBuilder] = innerEntities.map(mapElement).toMap

  private def mapElement(element: ModelDefaultBuilder): (String, ModelDefaultBuilder) = defaultIri(element) -> element

  private def defaultIri(metadata: ModelDefaultBuilder): String = metadata.`type`.head.iri()

}
