package org.mulesoft.apb.project.internal.dependency

import amf.core.client.scala.config.{CachedReference, UnitCache}
import org.mulesoft.apb.project.client.scala.dependency.{DesignDependency, UnitCacheBuilder}

import scala.concurrent.Future

object NothingUnitCacheBuilder extends UnitCacheBuilder {
  override def build(deps: Seq[DesignDependency]): UnitCache = NothingUnitCache
}

object NothingUnitCache extends UnitCache {
  override def fetch(url: String): Future[CachedReference] =
    Future.failed(CacheMissException("NothingUnitCache doesn't have any cached units"))
}

case class CacheMissException(message: String) extends Exception(message)
