package org.mulesoft.apb.project.internal.emitter

import amf.core.internal.render.emitters.PartEmitter
import amf.shapes.client.scala.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.{Documentation, DocumentationModel}
import org.mulesoft.apb.project.internal.emitter.EmitterUtils.emitScalarField
import org.mulesoft.common.client.lexical.Position
import org.yaml.model.YDocument.{EntryBuilder, PartBuilder}

class ProjectSummaryDocumentationEmitter(documentation: Documentation) extends PartEmitter {

  override def emit(partBuilder: PartBuilder): Unit = {
    partBuilder.obj { entryBuilder: EntryBuilder =>
      emitScalarField(entryBuilder, documentation, DocumentationModel.Name)
      emitScalarField(entryBuilder, documentation, DocumentationModel.Order)
      emitScalarField(entryBuilder, documentation, DocumentationModel.Path)
    }
  }

  override def position(): Position = Position.ZERO
}

object ProjectSummaryDocumentationEmitter {
  def apply(instance: JsonLDObject) = new ProjectSummaryDocumentationEmitter(Documentation(instance))
}
