package org.mulesoft.apb.project.client.platform.extensions

import amf.core.client.platform.model.StrField
import amf.core.client.platform.model.domain.DomainElement
import org.mulesoft.apb.project.client.platform.model.project.Project
import org.mulesoft.apb.project.client.scala.extensions.{
  EnvironmentExtension => InternalEnvironmentExtension,
  APIContractSchemaExtension => InternalAPIContractSchemaExtension
}
import org.mulesoft.apb.project.client.scala.extensions.environment.{InstanceEnvironment => InternalInstanceEnvironment}
import org.mulesoft.apb.project.client.scala.model.project.{Project => InternalProject}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._

import scala.scalajs.js.annotation.JSExportTopLevel

// This is only for project view, this shouldn't be exposed to JS
sealed trait APIProjectExtension {
  def extend(project: Project): Unit
}

case class EnvironmentExtension(private[apb] val envs: ClientList[InstanceEnvironment]) extends APIProjectExtension {
  override def extend(project: Project): Unit = {
    InternalEnvironmentExtension(envs.asInternal).extend(asInternal(project))
  }

  private def asInternal(project: Project): InternalProject = ProjectConverter.asInternal(project)
}

case class InstanceEnvironment private[apb] (_internal: InternalInstanceEnvironment) extends DomainElement {

  @JSExportTopLevel("InstanceEnvironment")
  def this() = this(InternalInstanceEnvironment())

  def environmentId(): StrField = StrFieldMatcher.asClient(_internal.environmentId())

  def name(): StrField = StrFieldMatcher.asClient(_internal.name())

  def `type`(): StrField = StrFieldMatcher.asClient(_internal.`type`())

  def withEnvironmentId(value: String): InstanceEnvironment = asClient(_internal.withEnvironmentId(value))

  def withName(value: String): InstanceEnvironment = asClient(_internal.withName(value))

  def withType(value: String): InstanceEnvironment = asClient(_internal.withType(value))

  private def asClient(internal: InternalInstanceEnvironment) = InstanceEnvironmentConverter.asClient(internal)
}

case class APIContractSchemaExtension(schemaURI: String) extends APIProjectExtension {
  override def extend(project: Project): Unit = {
    InternalAPIContractSchemaExtension(schemaURI).extend(project._internal)
  }
}
