package org.mulesoft.apb.project.client.platform.model.project.management

import amf.shapes.client.platform.model.domain.jsonldinstance.JsonLDObject
import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.project.management.PolicyBinding.DEFAULT_RULE_VALUE
import org.mulesoft.apb.project.client.scala.model.project.management.{PolicyBinding => InternalPolicyBinding}
import org.mulesoft.apb.project.internal.convert.ManagementClientConverters._
import amf.shapes.internal.convert.ShapeClientConverters.JsonLDObjectConverter
import org.mulesoft.apb.project.internal.model.GraphAccessors.toJsonLDObject

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class PolicyBinding(override private[apb] val internal: InternalPolicyBinding)
    extends DynamicObject(internal)
    with HasAnnotations
    with HasLabels
    with HasName {

  @JSExportTopLevel("PolicyBinding")
  def this(name: String) = this(InternalPolicyBinding(name))

  def getPolicy(): JsonLDObject = JsonLDObjectConverter.asClient(toJsonLDObject(internal))

  def namespace(): String = internal.namespace

  def withNamespace(namespace: String): this.type = {
    internal.withNamespace(namespace)
    this
  }

  def order(): Int = internal.order

  def withOrder(order: Int): this.type = {
    internal.withOrder(order)
    this
  }

  def policyRef(): PolicyRef = new PolicyRef(internal.policyRef)

  def withPolicyRef(name: String): this.type = {
    internal.withPolicyRef(name, None)
    this
  }

  def withPolicyRef(name: String, namespace: String): this.type = {
    internal.withPolicyRef(name, Some(namespace))
    this
  }

  def targetRef(): TargetRef = new TargetRef(internal.targetRef)

  def withTargetRef(name: String, kind: String): this.type = {
    internal.withTargetRef(name, kind)
    this
  }

  def getConfig(): JsonLDObject                     = JsonLDObjectConverter.asClient(internal.getConfig)
  def getConfigOption(): ClientOption[JsonLDObject] = internal.getConfigOption.asClient

  def getStringConfig(name: String): String        = internal.getScalarConfig[String](name)
  def getIntConfig(name: String): Int              = internal.getScalarConfig[Int](name)
  def getFloatConfig(name: String): Float          = internal.getScalarConfig[Float](name)
  def getDoubleConfig(name: String): Double        = internal.getScalarConfig[Double](name)
  def getBooleanConfig(name: String): Boolean      = internal.getScalarConfig[Boolean](name)
  def getObjectConfig(name: String): DynamicObject = new DynamicObject(internal.getObjectConfig(name))

  def withConfig(name: String, value: String): this.type = {
    internal.withConfig(name, value)
    this
  }

  def withConfig(name: String, value: Int): this.type = {
    internal.withConfig(name, value)
    this
  }

  def withConfig(name: String, value: Boolean): this.type = {
    internal.withConfig(name, value)
    this
  }

  def withConfig(name: String, value: Float): this.type = {
    internal.withConfig(name, value)
    this
  }

  def withConfig(name: String, value: Double): this.type = {
    internal.withConfig(name, value)
    this
  }

  def withConfig(name: String, value: DynamicObject): this.type = {
    internal.withConfig(name, value._internal)
    this
  }

  def withConfig(name: String, values: ClientList[String]): this.type = {
    internal.withConfig(name, values.asInternal.toList)
    this
  }

  def rules: ClientList[PolicyBindingRule] = internal.rules.asClient

  def withRule(
      path: String = DEFAULT_RULE_VALUE,
      method: String = DEFAULT_RULE_VALUE,
      host: String = DEFAULT_RULE_VALUE
  ): PolicyBindingRule = internal.withRule(path, method, host)

  def service: Service = internal.service

  def withService(name: String, address: String): Service = {
    internal.withService(name, address)
  }
}
