package org.mulesoft.apb.project.internal.convert

import amf.core.internal.convert.{BidirectionalMatcher, CoreBaseConverter}

trait ManagementBaseConverter
    extends CoreBaseConverter
    with APIInstanceConverter
    with PolicyBindingConverter
    with PolicyBindingRuleConverter
    with EnvironmentConverter
    with ServiceConverter
    with ServiceRouteConverter
    with TargetRefConverter
    with AlertConverter
    with ResourceConverter
    with ApiRefConverter
    with AlertConditionConverter
    with AlertFilterConverter
    with ResponseCodesFilterConverter
    with PolicyBindingFilterConverter
    with PolicyBindingRefConverter
    with AlertNotificationConverter

trait APIInstanceConverter {
  private type InternalAPIInstance = org.mulesoft.apb.project.client.scala.model.project.management.APIInstance
  private type ClientAPIInstance   = org.mulesoft.apb.project.client.platform.model.project.management.APIInstance
  implicit object APIInstanceConverter extends BidirectionalMatcher[InternalAPIInstance, ClientAPIInstance] {
    override def asClient(from: InternalAPIInstance): ClientAPIInstance   = new ClientAPIInstance(from)
    override def asInternal(from: ClientAPIInstance): InternalAPIInstance = from.internal
  }
}

trait PolicyBindingConverter {
  private type InternalPolicyBinding = org.mulesoft.apb.project.client.scala.model.project.management.PolicyBinding
  private type ClientPolicyBinding   = org.mulesoft.apb.project.client.platform.model.project.management.PolicyBinding
  implicit object PolicyBindingMatcher extends BidirectionalMatcher[InternalPolicyBinding, ClientPolicyBinding] {
    override def asClient(from: InternalPolicyBinding): ClientPolicyBinding   = new ClientPolicyBinding(from)
    override def asInternal(from: ClientPolicyBinding): InternalPolicyBinding = from.internal
  }
}

trait PolicyBindingRuleConverter {
  private type InternalPolicyBindingRule =
    org.mulesoft.apb.project.client.scala.model.project.management.PolicyBindingRule
  private type ClientPolicyBindingRule =
    org.mulesoft.apb.project.client.platform.model.project.management.PolicyBindingRule
  implicit object PolicyBindingRuleMatcher
      extends BidirectionalMatcher[InternalPolicyBindingRule, ClientPolicyBindingRule] {
    override def asClient(from: InternalPolicyBindingRule): ClientPolicyBindingRule = new ClientPolicyBindingRule(from)
    override def asInternal(from: ClientPolicyBindingRule): InternalPolicyBindingRule = from._internal
  }
}

trait EnvironmentConverter {
  private type InternalEnvironment = org.mulesoft.apb.project.client.scala.model.project.management.Environment
  private type ClientEnvironment   = org.mulesoft.apb.project.client.platform.model.project.management.Environment
  implicit object EnvironmentMatcher extends BidirectionalMatcher[InternalEnvironment, ClientEnvironment] {
    override def asClient(from: InternalEnvironment): ClientEnvironment   = new ClientEnvironment(from)
    override def asInternal(from: ClientEnvironment): InternalEnvironment = from.internal
  }
}

trait ServiceConverter {
  private type InternalService = org.mulesoft.apb.project.client.scala.model.project.management.Service
  private type ClientService   = org.mulesoft.apb.project.client.platform.model.project.management.Service
  implicit object ServiceMatcher extends BidirectionalMatcher[InternalService, ClientService] {
    override def asClient(from: InternalService): ClientService = new ClientService(from)

    override def asInternal(from: ClientService): InternalService = from.internal
  }
}

trait ServiceRouteConverter {
  private type InternalServiceRoute = org.mulesoft.apb.project.client.scala.model.project.management.ServiceRoute
  private type ClientServiceRoute   = org.mulesoft.apb.project.client.platform.model.project.management.ServiceRoute
  implicit object ServiceRouteMatcher extends BidirectionalMatcher[InternalServiceRoute, ClientServiceRoute] {
    override def asClient(from: InternalServiceRoute): ClientServiceRoute   = new ClientServiceRoute(from)
    override def asInternal(from: ClientServiceRoute): InternalServiceRoute = from._internal
  }
}

trait TargetRefConverter {
  private type InternalTargetRef = org.mulesoft.apb.project.client.scala.model.project.management.NamedRefWithKind
  private type ClientTargetRef   = org.mulesoft.apb.project.client.platform.model.project.management.TargetRef
  implicit object TargetRefMatcher extends BidirectionalMatcher[InternalTargetRef, ClientTargetRef] {
    override def asClient(from: InternalTargetRef): ClientTargetRef   = new ClientTargetRef(from)
    override def asInternal(from: ClientTargetRef): InternalTargetRef = from.internal
  }
}

trait AlertConverter {
  private type InternalAlert = org.mulesoft.apb.project.client.scala.model.project.management.Alert
  private type ClientAlert   = org.mulesoft.apb.project.client.platform.model.project.management.Alert
  implicit object AlertMatcher extends BidirectionalMatcher[InternalAlert, ClientAlert] {
    override def asClient(from: InternalAlert): ClientAlert   = new ClientAlert(from)
    override def asInternal(from: ClientAlert): InternalAlert = from.internal
  }
}

trait ResourceConverter {
  private type InternalResource = org.mulesoft.apb.project.client.scala.model.project.management.Resource
  private type ClientResource   = org.mulesoft.apb.project.client.platform.model.project.management.Resource
  implicit object ResourceMatcher extends BidirectionalMatcher[InternalResource, ClientResource] {
    override def asClient(from: InternalResource): ClientResource   = new ClientResource(from)
    override def asInternal(from: ClientResource): InternalResource = from.internal
  }
}

trait ApiRefConverter {
  private type InternalApiRef = org.mulesoft.apb.project.client.scala.model.project.management.ApiRef
  private type ClientApiRef   = org.mulesoft.apb.project.client.platform.model.project.management.ApiRef
  implicit object ApiRefMatcher extends BidirectionalMatcher[InternalApiRef, ClientApiRef] {
    override def asClient(from: InternalApiRef): ClientApiRef   = new ClientApiRef(from)
    override def asInternal(from: ClientApiRef): InternalApiRef = from.internal
  }
}

trait AlertConditionConverter {
  private type InternalAlertCondition = org.mulesoft.apb.project.client.scala.model.project.management.AlertCondition
  private type ClientAlertCondition   = org.mulesoft.apb.project.client.platform.model.project.management.AlertCondition
  implicit object AlertConditionMatcher extends BidirectionalMatcher[InternalAlertCondition, ClientAlertCondition] {
    override def asClient(from: InternalAlertCondition): ClientAlertCondition   = new ClientAlertCondition(from)
    override def asInternal(from: ClientAlertCondition): InternalAlertCondition = from.internal
  }
}

trait AlertFilterConverter {
  private type InternalAlertFilter =
    org.mulesoft.apb.project.client.scala.model.project.management.AlertFilter
  private type ClientAlertFilter =
    org.mulesoft.apb.project.client.platform.model.project.management.AlertFilter
  private type InternalResponseCodesFilter =
    org.mulesoft.apb.project.client.scala.model.project.management.ResponseCodesFilter
  private type ClientResponseCodesFilter =
    org.mulesoft.apb.project.client.platform.model.project.management.ResponseCodesFilter
  private type InternalPolicyBindingFilter =
    org.mulesoft.apb.project.client.scala.model.project.management.PolicyBindingFilter
  private type ClientPolicyBindingFilter =
    org.mulesoft.apb.project.client.platform.model.project.management.PolicyBindingFilter
  implicit object AlertFilterMatcher extends BidirectionalMatcher[InternalAlertFilter, ClientAlertFilter] {
    override def asClient(from: InternalAlertFilter): ClientAlertFilter = from match {
      case rcf: InternalResponseCodesFilter => new ClientResponseCodesFilter(rcf)
      case pbf: InternalPolicyBindingFilter => new ClientPolicyBindingFilter(pbf)
    }
    override def asInternal(from: ClientAlertFilter): InternalAlertFilter = from match {
      case rcf: ClientResponseCodesFilter => rcf.internal
      case pbf: ClientPolicyBindingFilter => pbf.internal
    }
  }
}

trait ResponseCodesFilterConverter {
  private type InternalResponseCodesFilter =
    org.mulesoft.apb.project.client.scala.model.project.management.ResponseCodesFilter
  private type ClientResponseCodesFilter =
    org.mulesoft.apb.project.client.platform.model.project.management.ResponseCodesFilter
  implicit object ResponseCodesFilterMatcher
      extends BidirectionalMatcher[InternalResponseCodesFilter, ClientResponseCodesFilter] {
    override def asClient(from: InternalResponseCodesFilter): ClientResponseCodesFilter = new ClientResponseCodesFilter(
        from
    )
    override def asInternal(from: ClientResponseCodesFilter): InternalResponseCodesFilter = from.internal
  }
}

trait PolicyBindingFilterConverter {
  private type InternalPolicyBindingFilter =
    org.mulesoft.apb.project.client.scala.model.project.management.PolicyBindingFilter
  private type ClientPolicyBindingFilter =
    org.mulesoft.apb.project.client.platform.model.project.management.PolicyBindingFilter
  implicit object PolicyBindingFilterMatcher
      extends BidirectionalMatcher[InternalPolicyBindingFilter, ClientPolicyBindingFilter] {
    override def asClient(from: InternalPolicyBindingFilter): ClientPolicyBindingFilter = new ClientPolicyBindingFilter(
        from
    )
    override def asInternal(from: ClientPolicyBindingFilter): InternalPolicyBindingFilter = from.internal
  }
}

trait PolicyBindingRefConverter {
  private type InternalPolicyBindingRef =
    org.mulesoft.apb.project.client.scala.model.project.management.PolicyBindingRef
  private type ClientPolicyBindingRef =
    org.mulesoft.apb.project.client.platform.model.project.management.PolicyBindingRef
  implicit object PolicyBindingRefMatcher
      extends BidirectionalMatcher[InternalPolicyBindingRef, ClientPolicyBindingRef] {
    override def asClient(from: InternalPolicyBindingRef): ClientPolicyBindingRef   = new ClientPolicyBindingRef(from)
    override def asInternal(from: ClientPolicyBindingRef): InternalPolicyBindingRef = from.internal
  }
}

trait AlertNotificationConverter {
  private type InternalAlertNotification =
    org.mulesoft.apb.project.client.scala.model.project.management.AlertNotification
  private type ClientAlertNotification =
    org.mulesoft.apb.project.client.platform.model.project.management.AlertNotification
  implicit object AlertNotificationMatcher
      extends BidirectionalMatcher[InternalAlertNotification, ClientAlertNotification] {
    override def asClient(from: InternalAlertNotification): ClientAlertNotification = new ClientAlertNotification(from)
    override def asInternal(from: ClientAlertNotification): InternalAlertNotification = from.internal
  }
}
