package org.mulesoft.apb.project.client.platform.model.descriptor.governance

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{Validation => InternalValidation}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}
import org.mulesoft.apb.project.internal.convert.APBProjectConverters._
import org.mulesoft.common.time.SimpleDateTime

@JSExportAll
case class Validation private[apb] (override private[apb] val _internal: InternalValidation)
    extends DynamicObject(_internal) {

  @JSExportTopLevel("Validation")
  def this(urn: String, assetId: String, group: String, version: String, status: Status, timestamp: SimpleDateTime) =
    this(InternalValidation(urn, assetId, group, version, status._internal, timestamp))

  def urn(): String       = _internal.urn
  def assetId(): String   = _internal.assetId
  def group(): String     = _internal.group
  def version(): String   = _internal.version
  def status(): Status    = _internal.status
  def timestamp(): String = _internal.timestamp

  def withUrn(urn: String): Validation = {
    _internal.withUrn(urn)
    this
  }

  def withAssetId(assetId: String): Validation = {
    _internal.withAssetId(assetId)
    this
  }

  def withGroup(group: String): Validation = {
    _internal.withGroup(group)
    this
  }
  def withVersion(version: String): Validation = {
    _internal.withVersion(version)
    this
  }

  def withStatus(status: Status): Validation = {
    _internal.withStatus(status._internal)
    this
  }

  def withTimestamp(timestamp: SimpleDateTime): Validation = {
    _internal.withTimestamp(timestamp)
    this
  }
}
