package org.mulesoft.apb.project.client.platform.model.project.management

import org.mulesoft.apb.project.client.platform.model.DynamicObject
import org.mulesoft.apb.project.internal.convert.ManagementClientConverters._
import amf.core.internal.convert.CoreClientConverters.InternalOptionOps
import amf.core.internal.convert.CoreClientConverters.InternalSeqOps
import amf.shapes.client.platform.model.domain.jsonldinstance.JsonLDObject
import amf.shapes.internal.convert.ShapeClientConverters.JsonLDObjectConverter
import org.mulesoft.apb.project.client.scala.model.project.management.{
  Alert => InternalAlert,
  AlertCondition => InternalAlertCondition,
  AlertNotification => InternalAlertNotification,
  ApiRef => InternalApiRef,
  PolicyBindingFilter => InternalPolicyBindingFilter,
  PolicyBindingRef => InternalPolicyBindingRef,
  Resource => InternalResource,
  ResponseCodesFilter => InternalResponseCodesFilter
}

import scala.scalajs.js.annotation.{JSExportAll, JSExportTopLevel}

@JSExportAll
class Alert(private[apb] val internal: InternalAlert)
    extends DynamicObject(internal)
    with HasName
    with HasMetadata
    with HasAnnotations
    with HasSpec {

  @JSExportTopLevel("Alert")
  def this(obj: JsonLDObject) = this(InternalAlert(JsonLDObjectConverter.asInternal(obj)))

  def resources(): ClientList[Resource] = internal.resources().asClient

  def condition(): ClientOption[AlertCondition] = internal.condition().asClient

  def interval(): ClientOption[Int] = internal.interval().asClient

  def notifications: ClientList[AlertNotification] = internal.notifications.asClient
}

@JSExportAll
class Resource(private[apb] val internal: InternalResource) extends DynamicObject(internal) {

  @JSExportTopLevel("Resource")
  def this(apiRef: String, propertyIri: String) = this(InternalResource(apiRef, propertyIri))

  def apiRef(): ClientOption[String] = internal.apiRef().asClient

  def filters(): ClientList[AlertFilter] = internal.filters().asClient
}

@JSExportAll
class ApiRef(private[apb] val internal: InternalApiRef) extends DynamicObject(internal) {

  @JSExportTopLevel("ApiRef")
  def this(value: String, propertyIri: String) = this(InternalApiRef(value, propertyIri))

  def name(): String = internal.name()
}

@JSExportAll
class AlertCondition(private[apb] val internal: InternalAlertCondition) extends DynamicObject(internal) {

  @JSExportTopLevel("AlertCondition")
  def this(obj: JsonLDObject) = this(InternalAlertCondition(JsonLDObjectConverter.asInternal(obj)))

  def metric(): ClientOption[String]    = internal.metric().asClient
  def operator(): ClientOption[String]  = internal.operator().asClient
  def threshold(): ClientOption[Double] = internal.threshold().asClient
}

@JSExportAll
trait AlertFilter

@JSExportAll
class ResponseCodesFilter(private[apb] val internal: InternalResponseCodesFilter)
    extends DynamicObject(internal)
    with AlertFilter {

  @JSExportTopLevel("ResponseCodesFilter")
  def this(obj: JsonLDObject) = this(InternalResponseCodesFilter(JsonLDObjectConverter.asInternal(obj)))

  def values(): ClientList[Int] = internal.values().asClient
}

@JSExportAll
case class PolicyBindingFilter(private[apb] val internal: InternalPolicyBindingFilter)
    extends DynamicObject(internal)
    with AlertFilter {

  @JSExportTopLevel("PolicyBindingFilter")
  def this(obj: JsonLDObject) = this(InternalPolicyBindingFilter(JsonLDObjectConverter.asInternal(obj)))

  def ref(): PolicyBindingRef = internal.ref()
}

@JSExportAll
case class PolicyBindingRef(private[apb] val internal: InternalPolicyBindingRef) extends DynamicObject(internal) {

  @JSExportTopLevel("PolicyBindingRef")
  def this(value: String, propertyIri: String) = this(InternalPolicyBindingRef(value, propertyIri))

  def name(): String = internal.name()
}

@JSExportAll
case class AlertNotification(private[apb] val internal: InternalAlertNotification) extends DynamicObject(internal) {

  @JSExportTopLevel("AlertNotification")
  def this(obj: JsonLDObject) = this(InternalAlertNotification(JsonLDObjectConverter.asInternal(obj)))

  def message(): ClientOption[String]  = internal.message().asClient
  def subject(): ClientOption[String]  = internal.subject().asClient
  def recipients(): ClientList[String] = internal.recipients().asClient
  def `type`(): ClientOption[String]   = internal.`type`().asClient
}
