package org.mulesoft.apb.project.internal.instances.inline

import org.mulesoft.apb.project.client.scala.model.project.management.{
  APIInstance,
  Alert,
  PolicyBindingFilter,
  Resource
}
import org.mulesoft.apb.project.internal.instances.AlertIndex

case class InlineAlert(index: AlertIndex) {

  def inlineInto(instance: APIInstance): Unit = {
    instance.policyBindings.foreach { binding =>
      val alerts = index.findForPolicyBinding(instance, binding)
      if (alerts.nonEmpty) binding.withAlerts(alerts)
      removeRefs(alerts, instance)
    }
    val alertsForInstance = index.findForApiInstance(instance)
    if (alertsForInstance.nonEmpty) instance.withAlerts(alertsForInstance)
    removeRefs(alertsForInstance, instance)
  }

  private def removeRefs(alerts: Seq[Alert], instance: APIInstance): Unit = alerts.foreach(removeRefs(_, instance))
  private def removeRefs(alert: Alert, instance: APIInstance): Alert = {
    val bindings = instance.policyBindings.flatMap(_.nameIfPresent).toSet
    removeRefs(alert, instance.name, bindings)
  }

  private def removeRefs(alert: Alert, instanceName: String, bindings: Set[String]): Alert = {
    val resources = resourcesForInstance(alert, instanceName).view
      .map { res => removePolicyBindingFilters(bindings, res) }
      .map { res => res.removeApiRef(); res }
      .filter { res => !res.isEmpty }
    if (resources.nonEmpty) alert.withResources(resources)
    else alert.removeResources()
  }

  private def removePolicyBindingFilters(bindings: Set[String], res: Resource) = {
    val filters = filterOutKnownPolicyBindingFilters(res, bindings)
    if (filters.nonEmpty) res.withFilters(filters)
    else res.removeFilters()
  }

  private def resourcesForInstance(alert: Alert, instanceName: String) = {
    alert.resources().filter(res => res.targetsInstance(instanceName) && !res.isEmpty)
  }

  private def filterOutKnownPolicyBindingFilters(res: Resource, bindings: Set[String]) = {
    res.filters().filter {
      case filter: PolicyBindingFilter => !bindings.contains(filter.ref().name())
      case _                           => true
    }
  }
}
