package org.mulesoft.apb.project.internal.convert

import amf.aml.client.scala.model.document.Dialect
import amf.apicontract.internal.convert.ApiBaseClientConverter
import amf.core.client.platform.resource
import amf.core.client.platform.resource.{ResourceLoader => ClientResourceLoader}
import amf.core.client.scala.resource.ResourceLoader
import amf.core.internal.convert.{
  BidirectionalMatcher,
  BidirectionalMatcherWithEC,
  InternalClientMatcher,
  InternalClientMatcherWithEC
}
import amf.core.internal.resource.{ClientResourceLoaderAdapter, InternalResourceLoaderAdapter}
import org.mulesoft.apb.project.client.platform.dependency.{
  DesignDependency => ClientDesignDependency,
  ExtensionDependency => ClientExtensionDependency,
  ParsedDependency => ClientParsedDependency,
  ProfileDependency => ClientProfileDependency,
  ManagementDependency => ClientManagementDependency
}
import org.mulesoft.apb.project.client.platform.descriptor.{DescriptorParseResult => ClientDescriptorParseResult}
import org.mulesoft.apb.project.client.platform.environment.{DependencyFetcher => ClientDependencyFetcher}
import org.mulesoft.apb.project.client.platform.extensions.{
  APIProjectExtension => ClientAPIProjectExtension,
  EnvironmentExtension => ClientEnvironmentExtension,
  InstanceEnvironment => ClientInstanceEnvironment
}
import org.mulesoft.apb.project.client.platform.model.descriptor.documentation.{
  Documentation => ClientDocumentationElement
}
import org.mulesoft.apb.project.client.platform.model.descriptor.community.{
  Community => ClientCommunity,
  CommunityProfile => ClientCommunityProfile,
  PortalTarget => ClientPortalTarget
}
import org.mulesoft.apb.project.client.platform.model.descriptor.governance.{Status => ClientStatus}
import org.mulesoft.apb.project.client.platform.model.descriptor.governance.{Validation => ClientValidation}
import org.mulesoft.apb.project.client.platform.model.descriptor.governance.{ValidationGroup => ClientValidationGroup}
import org.mulesoft.apb.project.client.platform.model.descriptor.governance.{GovernanceInfo => ClientGovernanceInfo}
import org.mulesoft.apb.project.client.platform.model.descriptor.{
  Gav => ClientGav,
  Instance => ClientApiInstance,
  Metadata => ClientMetadataElement,
  ProjectDependency => ClientProjectDependency,
  ProjectDescriptor => ClientProjectDescriptor,
  AttributeEntry => ClientAttributeEntry,
  FilePackaging => ClientFilePackaging
}
import org.mulesoft.apb.project.client.platform.model.project.{
  Project => ClientProject,
  ProjectInfo => ClientProjectInfo
}
import org.mulesoft.apb.project.client.platform.model.report.{
  APBReport => ClientAPBReport,
  APBResult => ClientAPBResult
}
import org.mulesoft.apb.project.client.platform.model.{
  BaseUnitBuildResult => ClientBaseUnitBuildResult,
  DynamicObject => ClientJsonLDObjectWrapper,
  JsonLDInstanceDocumentBuildResult => ClientJsonLDInstanceDocumentBuildResult,
  ProjectBuildResult => ClientProjectBuildResult
}
import org.mulesoft.apb.project.client.platform.{
  dependency,
  DependencySet => ClientDependencySet,
  DependencySetResult => ClientDependencySetResult
}
import org.mulesoft.apb.project.client.scala.dependency.{
  DesignDependency,
  ExtensionDependency,
  ManagementDependency,
  ParsedDependency,
  ProfileDependency
}
import org.mulesoft.apb.project.client.scala.descriptor.DescriptorParseResult
import org.mulesoft.apb.project.client.scala.environment.DependencyFetcher
import org.mulesoft.apb.project.client.scala.extensions.environment.InstanceEnvironment
import org.mulesoft.apb.project.client.scala.extensions.{APIProjectExtension, EnvironmentExtension}
import org.mulesoft.apb.project.client.scala.model.{
  BaseUnitBuildResult,
  DynamicObject,
  JsonLDInstanceDocumentBuildResult,
  ProjectBuildResult
}
import org.mulesoft.apb.project.client.scala.model.descriptor.community.{Community, CommunityProfile, PortalTarget}
import org.mulesoft.apb.project.client.scala.model.descriptor.documentation.Documentation
import org.mulesoft.apb.project.client.scala.model.project.{Project, ProjectInfo}
import org.mulesoft.apb.project.client.scala.model.descriptor._
import org.mulesoft.apb.project.client.scala.model.descriptor.governance.{
  GovernanceInfo,
  Status,
  Validation,
  ValidationGroup
}
import org.mulesoft.apb.project.client.scala.model.report.{APBReport, APBResult}
import org.mulesoft.apb.project.client.scala.{DependencySet, DependencySetResult}
import org.mulesoft.common.time.SimpleDateTime

import scala.concurrent.{ExecutionContext, Future}

trait APBProjectConverters extends ApiBaseClientConverter {
  implicit class FutureListConverter[Internal, Client](from: Future[Seq[Internal]])(implicit
      m: InternalClientMatcher[Internal, Client],
      executionContext: ExecutionContext
  ) {
    def asClient: ClientFuture[ClientList[Client]] = {
      asClientFuture(from.map(s => asClientList(s, m)))
    }
  }

  implicit object DependencySetConverter extends BidirectionalMatcherWithEC[DependencySet, ClientDependencySet] {

    override def asClient(from: DependencySet)(implicit executionContext: ExecutionContext): ClientDependencySet =
      new ClientDependencySetAdapter(from)

    override def asInternal(from: ClientDependencySet)(implicit executionContext: ExecutionContext): DependencySet =
      new InternalDependencySetAdapter(from)
  }

  implicit object DependencySetResultConverter
      extends InternalClientMatcherWithEC[DependencySetResult, ClientDependencySetResult] {

    override def asClient(from: DependencySetResult)(implicit
        executionContext: ExecutionContext
    ): ClientDependencySetResult =
      ClientDependencySetResult(from)
  }

  implicit object DependencyFetcherConverter extends BidirectionalMatcher[DependencyFetcher, ClientDependencyFetcher] {
    override def asInternal(from: ClientDependencyFetcher): DependencyFetcher = new InternalDependencyFetcherAdapter(
        from
    )

    override def asClient(from: DependencyFetcher): ClientDependencyFetcher = new ClientDependencyFetcherAdapter(from)
  }

  // TODO: we should have more missing cases here.
  implicit object ParsedDependencyConverter extends InternalClientMatcher[ParsedDependency, ClientParsedDependency] {
    override def asClient(from: ParsedDependency): ClientParsedDependency = from match {
      case d: DesignDependency     => ClientDesignDependency(d)
      case e: ExtensionDependency  => ClientExtensionDependency(e)
      case p: ProfileDependency    => ClientProfileDependency(p)
      case m: ManagementDependency => ClientManagementDependency(m)
    }
  }

  implicit object DesignDependencyConverter extends BidirectionalMatcher[DesignDependency, ClientDesignDependency] {
    override def asClient(from: DesignDependency): ClientDesignDependency   = ClientDesignDependency(from)
    override def asInternal(from: ClientDesignDependency): DesignDependency = from._internal
  }

  implicit object ExtensionDependencyConverter
      extends BidirectionalMatcher[ExtensionDependency, ClientExtensionDependency] {
    override def asClient(from: ExtensionDependency): ClientExtensionDependency   = ClientExtensionDependency(from)
    override def asInternal(from: ClientExtensionDependency): ExtensionDependency = from._internal
  }

  implicit object ProfileDependencyConverter extends BidirectionalMatcher[ProfileDependency, ClientProfileDependency] {
    override def asClient(from: ProfileDependency): ClientProfileDependency   = ClientProfileDependency(from)
    override def asInternal(from: ClientProfileDependency): ProfileDependency = from._internal
  }

  implicit object ManagementDependencyConverter
      extends BidirectionalMatcher[ManagementDependency, ClientManagementDependency] {
    override def asClient(from: ManagementDependency): ClientManagementDependency   = ClientManagementDependency(from)
    override def asInternal(from: ClientManagementDependency): ManagementDependency = from._internal
  }

  implicit object ProjectDescriptorConverter extends BidirectionalMatcher[ProjectDescriptor, ClientProjectDescriptor] {
    override def asClient(from: ProjectDescriptor): ClientProjectDescriptor   = ClientProjectDescriptor(from)
    override def asInternal(from: ClientProjectDescriptor): ProjectDescriptor = from._internal
  }

  implicit object GavMatcher extends BidirectionalMatcher[Gav, ClientGav] {
    override def asClient(from: Gav): ClientGav   = ClientGav(from)
    override def asInternal(from: ClientGav): Gav = from._internal
  }

  implicit object AttributeEntryMatcher extends BidirectionalMatcher[AttributeEntry, ClientAttributeEntry] {
    override def asClient(from: AttributeEntry): ClientAttributeEntry   = ClientAttributeEntry(from)
    override def asInternal(from: ClientAttributeEntry): AttributeEntry = from._internal
  }

  implicit object FilePackagingMatcher extends BidirectionalMatcher[FilePackaging, ClientFilePackaging] {
    override def asClient(from: FilePackaging): ClientFilePackaging   = ClientFilePackaging(from)
    override def asInternal(from: ClientFilePackaging): FilePackaging = from._internal
  }

  implicit object MetadataElementMatcher extends BidirectionalMatcher[Metadata, ClientMetadataElement] {
    override def asClient(from: Metadata): ClientMetadataElement   = ClientMetadataElement(from)
    override def asInternal(from: ClientMetadataElement): Metadata = from._internal
  }

  implicit object DocumentationElementMatcher extends BidirectionalMatcher[Documentation, ClientDocumentationElement] {
    override def asClient(from: Documentation): ClientDocumentationElement = ClientDocumentationElement(from)

    override def asInternal(from: ClientDocumentationElement): Documentation = from._internal
  }

  implicit object CommunityMatcher extends BidirectionalMatcher[Community, ClientCommunity] {
    override def asClient(from: Community): ClientCommunity = ClientCommunity(from)

    override def asInternal(from: ClientCommunity): Community = from._internal
  }

  implicit object PortalTargetMatcher extends BidirectionalMatcher[PortalTarget, ClientPortalTarget] {
    override def asClient(from: PortalTarget): ClientPortalTarget = ClientPortalTarget(from)

    override def asInternal(from: ClientPortalTarget): PortalTarget = from._internal
  }

  implicit object CommunityProfileMatcher extends BidirectionalMatcher[CommunityProfile, ClientCommunityProfile] {
    override def asClient(from: CommunityProfile): ClientCommunityProfile = ClientCommunityProfile(from)

    override def asInternal(from: ClientCommunityProfile): CommunityProfile = from._internal
  }

  implicit object ValidationStatusMatcher extends BidirectionalMatcher[Status, ClientStatus] {
    override def asClient(from: Status): ClientStatus = ClientStatus(from)

    override def asInternal(from: ClientStatus): Status = from._internal
  }

  implicit object ValidationMatcher extends BidirectionalMatcher[Validation, ClientValidation] {
    override def asClient(from: Validation): ClientValidation = ClientValidation(from)

    override def asInternal(from: ClientValidation): Validation = from._internal
  }

  implicit object ValidationGroupMatcher extends BidirectionalMatcher[ValidationGroup, ClientValidationGroup] {
    override def asClient(from: ValidationGroup): ClientValidationGroup = ClientValidationGroup(from)

    override def asInternal(from: ClientValidationGroup): ValidationGroup = from._internal
  }

  implicit object GovernanceInfoMatcher extends BidirectionalMatcher[GovernanceInfo, ClientGovernanceInfo] {
    override def asClient(from: GovernanceInfo): ClientGovernanceInfo = ClientGovernanceInfo(from)

    override def asInternal(from: ClientGovernanceInfo): GovernanceInfo = from._internal
  }

  implicit object ProjectDependencyMatcher extends BidirectionalMatcher[ProjectDependency, ClientProjectDependency] {
    override def asClient(from: ProjectDependency): ClientProjectDependency   = ClientProjectDependency(from)
    override def asInternal(from: ClientProjectDependency): ProjectDependency = from._internal
  }

  implicit object DescriptorParseResultMatcher
      extends BidirectionalMatcher[DescriptorParseResult, ClientDescriptorParseResult] {
    override def asClient(from: DescriptorParseResult): ClientDescriptorParseResult = ClientDescriptorParseResult(from)
    override def asInternal(from: ClientDescriptorParseResult): DescriptorParseResult = from._internal
  }

  implicit object InstanceMatcher extends BidirectionalMatcher[Instance, ClientApiInstance] {
    override def asClient(from: Instance): ClientApiInstance = ClientApiInstance(from)

    override def asInternal(from: ClientApiInstance): Instance = from._internal
  }

  implicit object JsonLDObjectWrapperConverter extends BidirectionalMatcher[DynamicObject, ClientJsonLDObjectWrapper] {
    override def asClient(from: DynamicObject): ClientJsonLDObjectWrapper = from match {
      case m: Metadata                   => ClientMetadataElement(m)
      case pd: ProjectDescriptor         => ClientProjectDescriptor(pd)
      case dependency: ProjectDependency => ClientProjectDependency(dependency)
      case instance: Instance            => ClientApiInstance(instance)
    }

    override def asInternal(from: ClientJsonLDObjectWrapper): DynamicObject = from._internal
  }

  implicit object APBProjectInfoConverter extends InternalClientMatcher[ProjectInfo, ClientProjectInfo] {
    override def asClient(from: ProjectInfo): ClientProjectInfo = new ClientProjectInfo(from)
  }

  implicit object InstanceEnvironmentConverter
      extends BidirectionalMatcher[InstanceEnvironment, ClientInstanceEnvironment] {
    override def asClient(from: InstanceEnvironment): ClientInstanceEnvironment = ClientInstanceEnvironment(from)

    override def asInternal(from: ClientInstanceEnvironment): InstanceEnvironment = from._internal
  }

  implicit object ProjectConverter extends BidirectionalMatcher[Project, ClientProject] {
    override def asClient(from: Project): ClientProject = ClientProject(from)

    override def asInternal(from: ClientProject): Project = from._internal
  }

  implicit object APIProjectExtensionMatcher
      extends BidirectionalMatcher[APIProjectExtension, ClientAPIProjectExtension] {
    // APIProjectExtension is a sealed trait. That is why we can match without worrying about Match Errors
    override def asClient(from: APIProjectExtension): ClientAPIProjectExtension = from match {
      case ext: EnvironmentExtension => ClientEnvironmentExtension(ext.envs.asClient)
    }

    override def asInternal(from: ClientAPIProjectExtension): APIProjectExtension = from match {
      case ext: ClientEnvironmentExtension => EnvironmentExtension(ext.envs.asInternal)
    }
  }

  implicit object BaseUnitBuildResultConverter
      extends BidirectionalMatcher[BaseUnitBuildResult, ClientBaseUnitBuildResult] {
    override def asClient(from: BaseUnitBuildResult): ClientBaseUnitBuildResult = ClientBaseUnitBuildResult(from)

    override def asInternal(from: ClientBaseUnitBuildResult): BaseUnitBuildResult = from._internal
  }

  implicit object ProjectBuildResultConverter
      extends BidirectionalMatcher[ProjectBuildResult, ClientProjectBuildResult] {
    override def asClient(from: ProjectBuildResult): ClientProjectBuildResult = ClientProjectBuildResult(from)

    override def asInternal(from: ClientProjectBuildResult): ProjectBuildResult = from._internal
  }

  implicit object JsonLDInstanceDocumentBuildResultConverter
      extends BidirectionalMatcher[JsonLDInstanceDocumentBuildResult, ClientJsonLDInstanceDocumentBuildResult] {
    override def asClient(from: JsonLDInstanceDocumentBuildResult): ClientJsonLDInstanceDocumentBuildResult =
      ClientJsonLDInstanceDocumentBuildResult(from)

    override def asInternal(from: ClientJsonLDInstanceDocumentBuildResult): JsonLDInstanceDocumentBuildResult =
      from._internal
  }

  class InternalDependencyFetcherAdapter(from: ClientDependencyFetcher) extends DependencyFetcher {
    override def accepts(dependency: ProjectDependency): Boolean = {
      from.accepts(dependency)
    }

    override def fetch(dependency: ProjectDependency): ResourceLoader = {
      ResourceLoaderMatcher.asInternal(from.fetch(dependency))(ExecutionContext.Implicits.global)
    }
  }

  class ClientDependencyFetcherAdapter(from: DependencyFetcher) extends ClientDependencyFetcher {
    override def accepts(dependency: ClientProjectDependency): Boolean = {
      from.accepts(dependency)
    }

    override def fetch(dependency: ClientProjectDependency): resource.ResourceLoader = {
      ResourceLoaderMatcher.asClient(from.fetch(dependency))(ExecutionContext.Implicits.global)
    }
  }

  class ClientDependencySetAdapter(from: DependencySet)(implicit ec: ExecutionContext) extends ClientDependencySet {
    override def design(): ClientList[ClientDesignDependency] = from.design().asClient

    override def validation(): ClientList[ClientProfileDependency] = from.validation().asClient

    override def designExtension(): ClientList[ClientExtensionDependency] = from.designExtension().asClient

    override def management(): ClientList[ClientManagementDependency] = from.management().asClient

    override def validationDialect(): Dialect = from.validationDialect()

    override def descriptor(): ClientProjectDescriptor = from.descriptor()

    override def dependencyLoaders(): ClientMap[ClientResourceLoader] = {
      val rlMatcher = new InternalClientMatcher[ResourceLoader, ClientResourceLoader] {
        override def asClient(from: ResourceLoader): ClientResourceLoader = ClientResourceLoaderAdapter(from)
      }
      InternalImmutableMapOps(from.dependencyLoaders())(rlMatcher).asClient
    }

    override def allDependencies(): ClientList[ClientParsedDependency] = from.allDependencies().asClient

    override def mainLoader(): ClientResourceLoader = ClientResourceLoaderAdapter(from.mainLoader())
  }

  class InternalDependencySetAdapter(from: ClientDependencySet)(implicit ec: ExecutionContext) extends DependencySet {
    override def design(): Seq[DesignDependency] = from.design().asInternal

    override def validation(): Seq[ProfileDependency] = from.validation().asInternal

    override def designExtension(): Seq[ExtensionDependency] = from.designExtension().asInternal

    override def management(): Seq[ManagementDependency] = from.management().asInternal

    override def validationDialect(): Dialect = from.validationDialect()

    override def descriptor(): ProjectDescriptor = from.descriptor()

    override def dependencyLoaders(): Map[String, ResourceLoader] = Map.empty // TODO: revisit

    override def allDependencies(): Seq[ParsedDependency] = Seq.empty // TODO: revisit

    override def mainLoader(): ResourceLoader = InternalResourceLoaderAdapter(from.mainLoader())
  }

  implicit object APBResultConverter extends BidirectionalMatcher[APBResult, ClientAPBResult] {
    override def asClient(from: APBResult): ClientAPBResult = new ClientAPBResult(from)

    override def asInternal(from: ClientAPBResult): APBResult = from._internal
  }

  implicit object APBReportConverter extends BidirectionalMatcher[APBReport, ClientAPBReport] {
    override def asClient(from: APBReport): ClientAPBReport = new ClientAPBReport(from)

    override def asInternal(from: ClientAPBReport): APBReport = from._internal
  }

  implicit object SimpleDateTimeMatcher extends IdentityMatcher[SimpleDateTime]
}

object APBProjectConverters extends APBProjectConverters
